/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util.configuration;

import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.configuration.AbstractConfiguration;
import com.alibaba.antx.util.configuration.Configuration;
import com.alibaba.antx.util.configuration.ConfigurationException;
import com.alibaba.antx.util.configuration.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultConfiguration
extends AbstractConfiguration
implements Serializable {
    private static final long serialVersionUID = 3545521720271452213L;
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final Location m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(String name) {
        this(name, null, "", "");
    }

    public DefaultConfiguration(String name, Location location) {
        this(name, location, "", "");
    }

    public DefaultConfiguration(String name, Location location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public Location getLocation() {
        return this.m_location;
    }

    public String getValue(String defaultValue) {
        if (!StringUtil.isEmpty(this.m_value)) {
            return this.m_value;
        }
        return defaultValue;
    }

    public String getValue() throws ConfigurationException {
        if (!StringUtil.isEmpty(this.m_value)) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (!StringUtil.isEmpty(value)) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, Location.EMPTY_LOCATION);
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        for (int i = 0; i < size; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new Configuration[0]);
    }

    @Deprecated
    public void appendValueData(String value) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? value : this.m_value + value;
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    @Deprecated
    public String addAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void addAll(Configuration other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(Configuration other) {
        String[] attributes;
        this.checkWriteable();
        for (String name : attributes = other.getAttributeNames()) {
            String value = other.getAttribute(name, null);
            this.setAttribute(name, value);
        }
    }

    public void addAllChildren(Configuration other) {
        Configuration[] children;
        this.checkWriteable();
        for (Configuration element : children = other.getChildren()) {
            this.addChild(element);
        }
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }
}

