/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.enumeration.FlagSet;
import com.alibaba.toolkit.util.enumeration.Flags;
import com.alibaba.toolkit.util.enumeration.IntegerEnum;
import java.text.MessageFormat;

public abstract class IntegerFlagSet
extends FlagSet {
    private static final long serialVersionUID = 397018141070555601L;
    private int value;

    public IntegerFlagSet(Class enumClass) {
        super(enumClass);
        if (!IntegerEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), IntegerEnum.class.getName()));
        }
    }

    public void setValue(Object value) {
        this.checkImmutable();
        if (value == null) {
            throw new NullPointerException("FlagSet value must not be null");
        }
        this.value = (Integer)value;
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public Flags clear() {
        this.checkImmutable();
        this.value = 0;
        return this;
    }

    public boolean test(Flags flags) {
        return (this.value & this.getFlagsValue(flags)) != 0;
    }

    public boolean testAll(Flags flags) {
        int testValue = this.getFlagsValue(flags);
        return (this.value & testValue) == testValue;
    }

    public Flags and(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags);
        return flagSet;
    }

    public Flags andNot(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value &= ~this.getFlagsValue(flags);
        return flagSet;
    }

    public Flags or(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value |= this.getFlagsValue(flags);
        return flagSet;
    }

    public Flags xor(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value ^= this.getFlagsValue(flags);
        return flagSet;
    }

    private int getFlagsValue(Flags flags) {
        this.checkFlags(flags);
        return flags instanceof IntegerEnum ? ((IntegerEnum)((Object)flags)).intValue() : ((IntegerFlagSet)flags).value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public String toHexString() {
        return Integer.toHexString(this.value);
    }

    public String toOctalString() {
        return Integer.toOctalString(this.value);
    }

    public String toBinaryString() {
        return Integer.toBinaryString(this.value);
    }
}

