/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.enumeration.FlagSet;
import com.alibaba.toolkit.util.enumeration.Flags;
import com.alibaba.toolkit.util.enumeration.LongEnum;
import java.text.MessageFormat;

public abstract class LongFlagSet
extends FlagSet {
    private static final long serialVersionUID = -7159161922846089638L;
    private long value;

    public LongFlagSet(Class enumClass) {
        super(enumClass);
        if (!LongEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), LongEnum.class.getName()));
        }
    }

    public void setValue(Object value) {
        this.checkImmutable();
        if (value == null) {
            throw new NullPointerException("FlagSet value must not be null");
        }
        this.value = (Long)value;
    }

    public Object getValue() {
        return new Long(this.value);
    }

    public Flags clear() {
        this.checkImmutable();
        this.value = 0L;
        return this;
    }

    public boolean test(Flags flags) {
        return (this.value & this.getFlagsValue(flags)) != 0L;
    }

    public boolean testAll(Flags flags) {
        long testValue = this.getFlagsValue(flags);
        return (this.value & testValue) == testValue;
    }

    public Flags and(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags);
        return flagSet;
    }

    public Flags andNot(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags) ^ 0xFFFFFFFFFFFFFFFFL;
        return flagSet;
    }

    public Flags or(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value |= this.getFlagsValue(flags);
        return flagSet;
    }

    public Flags xor(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value ^= this.getFlagsValue(flags);
        return flagSet;
    }

    private long getFlagsValue(Flags flags) {
        this.checkFlags(flags);
        return flags instanceof LongEnum ? ((LongEnum)((Object)flags)).longValue() : ((LongFlagSet)flags).value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public String toHexString() {
        return Long.toHexString(this.value);
    }

    public String toOctalString() {
        return Long.toOctalString(this.value);
    }

    public String toBinaryString() {
        return Long.toBinaryString(this.value);
    }
}

