/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.typeconvert.converters;

import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;

public class CharacterConverter
implements Converter {
    protected static final Character DEFAULT_VALUE = new Character('\u0000');

    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Character) {
            return value;
        }
        if (value instanceof Number) {
            return new Character((char)((Number)value).intValue());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return new Character((char)Integer.decode(strValue).intValue());
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

