/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.Out;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagTable;

public class PPrint {
    public static final short EFFECT_BLEND = -1;
    public static final short EFFECT_BOX_IN = 0;
    public static final short EFFECT_BOX_OUT = 1;
    public static final short EFFECT_CIRCLE_IN = 2;
    public static final short EFFECT_CIRCLE_OUT = 3;
    public static final short EFFECT_WIPE_UP = 4;
    public static final short EFFECT_WIPE_DOWN = 5;
    public static final short EFFECT_WIPE_RIGHT = 6;
    public static final short EFFECT_WIPE_LEFT = 7;
    public static final short EFFECT_VERT_BLINDS = 8;
    public static final short EFFECT_HORZ_BLINDS = 9;
    public static final short EFFECT_CHK_ACROSS = 10;
    public static final short EFFECT_CHK_DOWN = 11;
    public static final short EFFECT_RND_DISSOLVE = 12;
    public static final short EFFECT_SPLIT_VIRT_IN = 13;
    public static final short EFFECT_SPLIT_VIRT_OUT = 14;
    public static final short EFFECT_SPLIT_HORZ_IN = 15;
    public static final short EFFECT_SPLIT_HORZ_OUT = 16;
    public static final short EFFECT_STRIPS_LEFT_DOWN = 17;
    public static final short EFFECT_STRIPS_LEFT_UP = 18;
    public static final short EFFECT_STRIPS_RIGHT_DOWN = 19;
    public static final short EFFECT_STRIPS_RIGHT_UP = 20;
    public static final short EFFECT_RND_BARS_HORZ = 21;
    public static final short EFFECT_RND_BARS_VERT = 22;
    public static final short EFFECT_RANDOM = 23;
    private static final short NORMAL = 0;
    private static final short PREFORMATTED = 1;
    private static final short COMMENT = 2;
    private static final short ATTRIBVALUE = 4;
    private static final short NOWRAP = 8;
    private static final short CDATA = 16;
    private int[] linebuf = null;
    private int lbufsize = 0;
    private int linelen = 0;
    private int wraphere = 0;
    private boolean inAttVal = false;
    private boolean InString = false;
    private int slide = 0;
    private int count = 0;
    private Node slidecontent = null;
    private Configuration configuration;

    public PPrint(Configuration configuration) {
        this.configuration = configuration;
    }

    public static int getUTF8(byte[] str, int start, MutableInteger ch) {
        int bytes;
        int n;
        int c = str[start] & 0xFF;
        if ((c & 0xE0) == 192) {
            n = c & 0x1F;
            bytes = 2;
        } else if ((c & 0xF0) == 224) {
            n = c & 0xF;
            bytes = 3;
        } else if ((c & 0xF8) == 240) {
            n = c & 7;
            bytes = 4;
        } else if ((c & 0xFC) == 248) {
            n = c & 3;
            bytes = 5;
        } else if ((c & 0xFE) == 252) {
            n = c & 1;
            bytes = 6;
        } else {
            ch.value = c;
            return 0;
        }
        for (int i = 1; i < bytes; ++i) {
            c = str[start + i] & 0xFF;
            n = n << 6 | c & 0x3F;
        }
        ch.value = n;
        return bytes - 1;
    }

    public static int putUTF8(byte[] buf, int start, int c) {
        if (c < 128) {
            buf[start++] = (byte)c;
        } else if (c <= 2047) {
            buf[start++] = (byte)(0xC0 | c >> 6);
            buf[start++] = (byte)(0x80 | c & 0x3F);
        } else if (c <= 65535) {
            buf[start++] = (byte)(0xE0 | c >> 12);
            buf[start++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[start++] = (byte)(0x80 | c & 0x3F);
        } else if (c <= 0x1FFFFF) {
            buf[start++] = (byte)(0xF0 | c >> 18);
            buf[start++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[start++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[start++] = (byte)(0x80 | c & 0x3F);
        } else {
            buf[start++] = (byte)(0xF8 | c >> 24);
            buf[start++] = (byte)(0x80 | c >> 18 & 0x3F);
            buf[start++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[start++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[start++] = (byte)(0x80 | c & 0x3F);
        }
        return start;
    }

    private void addC(int c, int index) {
        if (index + 1 >= this.lbufsize) {
            while (index + 1 >= this.lbufsize) {
                if (this.lbufsize == 0) {
                    this.lbufsize = 256;
                    continue;
                }
                this.lbufsize *= 2;
            }
            int[] temp = new int[this.lbufsize];
            if (this.linebuf != null) {
                System.arraycopy(this.linebuf, 0, temp, 0, index);
            }
            this.linebuf = temp;
        }
        this.linebuf[index] = c;
    }

    private void wrapLine(Out fout, int indent) {
        int i;
        if (this.wraphere == 0) {
            return;
        }
        for (i = 0; i < indent; ++i) {
            fout.outc(32);
        }
        for (i = 0; i < this.wraphere; ++i) {
            fout.outc(this.linebuf[i]);
        }
        if (this.InString) {
            fout.outc(32);
            fout.outc(92);
        }
        fout.newline();
        if (this.linelen > this.wraphere) {
            int p = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int q = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[p] = this.linebuf[q];
                if (this.linebuf[q] == 0) break;
                ++p;
                ++q;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    private void wrapAttrVal(Out fout, int indent, boolean inString) {
        int i;
        for (i = 0; i < indent; ++i) {
            fout.outc(32);
        }
        for (i = 0; i < this.wraphere; ++i) {
            fout.outc(this.linebuf[i]);
        }
        fout.outc(32);
        if (inString) {
            fout.outc(92);
        }
        fout.newline();
        if (this.linelen > this.wraphere) {
            int p = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int q = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[p] = this.linebuf[q];
                if (this.linebuf[q] == 0) break;
                ++p;
                ++q;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    public void flushLine(Out fout, int indent) {
        if (this.linelen > 0) {
            int i;
            if (indent + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(fout, indent);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                for (i = 0; i < indent; ++i) {
                    fout.outc(32);
                }
            }
            for (i = 0; i < this.linelen; ++i) {
                fout.outc(this.linebuf[i]);
            }
        }
        fout.newline();
        this.linelen = 0;
        this.wraphere = 0;
        this.inAttVal = false;
    }

    public void condFlushLine(Out fout, int indent) {
        if (this.linelen > 0) {
            int i;
            if (indent + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(fout, indent);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                for (i = 0; i < indent; ++i) {
                    fout.outc(32);
                }
            }
            for (i = 0; i < this.linelen; ++i) {
                fout.outc(this.linebuf[i]);
            }
            fout.newline();
            this.linelen = 0;
            this.wraphere = 0;
            this.inAttVal = false;
        }
    }

    private void printChar(int c, short mode) {
        if (c == 32 && (mode & 7) == 0) {
            if ((mode & 8) != 0) {
                if (this.configuration.NumEntities || this.configuration.XmlTags) {
                    this.addC(38, this.linelen++);
                    this.addC(35, this.linelen++);
                    this.addC(49, this.linelen++);
                    this.addC(54, this.linelen++);
                    this.addC(48, this.linelen++);
                    this.addC(59, this.linelen++);
                } else {
                    this.addC(38, this.linelen++);
                    this.addC(110, this.linelen++);
                    this.addC(98, this.linelen++);
                    this.addC(115, this.linelen++);
                    this.addC(112, this.linelen++);
                    this.addC(59, this.linelen++);
                }
                return;
            }
            this.wraphere = this.linelen;
        }
        if ((mode & 2) != 0) {
            this.addC(c, this.linelen++);
            return;
        }
        if ((mode & 0x10) == 0) {
            if (c == 60) {
                this.addC(38, this.linelen++);
                this.addC(108, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (c == 62) {
                this.addC(38, this.linelen++);
                this.addC(103, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (c == 38 && this.configuration.QuoteAmpersand) {
                this.addC(38, this.linelen++);
                this.addC(97, this.linelen++);
                this.addC(109, this.linelen++);
                this.addC(112, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (c == 34 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(113, this.linelen++);
                this.addC(117, this.linelen++);
                this.addC(111, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (c == 39 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(35, this.linelen++);
                this.addC(51, this.linelen++);
                this.addC(57, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (c == 160 && this.configuration.CharEncoding != 0) {
                if (this.configuration.QuoteNbsp) {
                    this.addC(38, this.linelen++);
                    if (this.configuration.NumEntities) {
                        this.addC(35, this.linelen++);
                        this.addC(49, this.linelen++);
                        this.addC(54, this.linelen++);
                        this.addC(48, this.linelen++);
                    } else {
                        this.addC(110, this.linelen++);
                        this.addC(98, this.linelen++);
                        this.addC(115, this.linelen++);
                        this.addC(112, this.linelen++);
                    }
                    this.addC(59, this.linelen++);
                } else {
                    this.addC(c, this.linelen++);
                }
                return;
            }
        }
        if (this.configuration.CharEncoding == 4 || this.configuration.CharEncoding == 0) {
            this.addC(c, this.linelen++);
            return;
        }
        if (c == 160 && (mode & 1) != 0) {
            this.addC(32, this.linelen++);
            return;
        }
        if (this.configuration.MakeClean && c >= 8211 && c <= 8222) {
            switch (c) {
                case 8211: 
                case 8212: {
                    c = 45;
                    break;
                }
                case 8216: 
                case 8217: 
                case 8218: {
                    c = 39;
                    break;
                }
                case 8220: 
                case 8221: 
                case 8222: {
                    c = 34;
                }
            }
        }
        if (this.configuration.CharEncoding == 2) {
            if (c > 255) {
                String entity;
                entity = !this.configuration.NumEntities ? ((entity = EntityTable.getDefaultEntityTable().entityName((short)c)) != null ? "&" + entity + ";" : "&#" + c + ";") : "&#" + c + ";";
                for (int i = 0; i < entity.length(); ++i) {
                    this.addC(entity.charAt(i), this.linelen++);
                }
                return;
            }
            if (c > 126 && c < 160) {
                String entity = "&#" + c + ";";
                for (int i = 0; i < entity.length(); ++i) {
                    this.addC(entity.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(c, this.linelen++);
            return;
        }
        if (this.configuration.CharEncoding == 3) {
            this.addC(c, this.linelen++);
            return;
        }
        if (this.configuration.XmlTags) {
            if (c > 127 && this.configuration.CharEncoding == 1) {
                String entity = "&#" + c + ";";
                for (int i = 0; i < entity.length(); ++i) {
                    this.addC(entity.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(c, this.linelen++);
            return;
        }
        if (c > 126 || c < 32 && c != 9) {
            String entity;
            entity = !this.configuration.NumEntities ? ((entity = EntityTable.getDefaultEntityTable().entityName((short)c)) != null ? "&" + entity + ";" : "&#" + c + ";") : "&#" + c + ";";
            for (int i = 0; i < entity.length(); ++i) {
                this.addC(entity.charAt(i), this.linelen++);
            }
            return;
        }
        this.addC(c, this.linelen++);
    }

    private void printText(Out fout, short mode, int indent, byte[] textarray, int start, int end) {
        MutableInteger ci = new MutableInteger();
        for (int i = start; i < end; ++i) {
            int c;
            if (indent + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(fout, indent);
            }
            if ((c = textarray[i] & 0xFF) > 127) {
                i += PPrint.getUTF8(textarray, i, ci);
                c = ci.value;
            }
            if (c == 10) {
                this.flushLine(fout, indent);
                continue;
            }
            this.printChar(c, mode);
        }
    }

    private void printString(Out fout, int indent, String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.addC(str.charAt(i), this.linelen++);
        }
    }

    private void printAttrValue(Out fout, int indent, String value, int delim, boolean wrappable) {
        short mode;
        MutableInteger ci = new MutableInteger();
        boolean wasinstring = false;
        byte[] valueChars = null;
        short s = mode = wrappable ? (short)4 : 5;
        if (value != null) {
            valueChars = Lexer.getBytes(value);
        }
        if (valueChars != null && valueChars.length >= 5 && valueChars[0] == 60 && (valueChars[1] == 37 || valueChars[1] == 64 || new String(valueChars, 0, 5).equals("<?php"))) {
            mode = (short)(mode | 0x10);
        }
        if (delim == 0) {
            delim = 34;
        }
        this.addC(61, this.linelen++);
        if (!this.configuration.XmlOut) {
            if (indent + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
            if (indent + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(fout, indent);
            }
            if (indent + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            } else {
                this.condFlushLine(fout, indent);
            }
        }
        this.addC(delim, this.linelen++);
        if (value != null) {
            this.InString = false;
            int i = 0;
            while (i < valueChars.length) {
                int c = valueChars[i] & 0xFF;
                if (wrappable && c == 32 && indent + this.linelen < this.configuration.wraplen) {
                    this.wraphere = this.linelen;
                    wasinstring = this.InString;
                }
                if (wrappable && this.wraphere > 0 && indent + this.linelen >= this.configuration.wraplen) {
                    this.wrapAttrVal(fout, indent, wasinstring);
                }
                if (c == delim) {
                    String entity = c == 34 ? "&quot;" : "&#39;";
                    for (int j = 0; j < entity.length(); ++j) {
                        this.addC(entity.charAt(j), this.linelen++);
                    }
                    ++i;
                    continue;
                }
                if (c == 34) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(113, this.linelen++);
                        this.addC(117, this.linelen++);
                        this.addC(111, this.linelen++);
                        this.addC(116, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(34, this.linelen++);
                    }
                    if (delim == 39) {
                        this.InString = !this.InString;
                    }
                    ++i;
                    continue;
                }
                if (c == 39) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(35, this.linelen++);
                        this.addC(51, this.linelen++);
                        this.addC(57, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(39, this.linelen++);
                    }
                    if (delim == 34) {
                        this.InString = !this.InString;
                    }
                    ++i;
                    continue;
                }
                if (c > 127) {
                    i += PPrint.getUTF8(valueChars, i, ci);
                    c = ci.value;
                }
                ++i;
                if (c == 10) {
                    this.flushLine(fout, indent);
                    continue;
                }
                this.printChar(c, mode);
            }
        }
        this.InString = false;
        this.addC(delim, this.linelen++);
    }

    private void printAttribute(Out fout, int indent, Node node, AttVal attr) {
        boolean wrappable = false;
        if (this.configuration.IndentAttributes) {
            this.flushLine(fout, indent);
            indent += this.configuration.spaces;
        }
        String name = attr.attribute;
        if (indent + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(fout, indent);
        }
        if (!this.configuration.XmlTags && !this.configuration.XmlOut && attr.dict != null) {
            if (AttributeTable.getDefaultAttributeTable().isScript(name)) {
                wrappable = this.configuration.WrapScriptlets;
            } else if (!attr.dict.nowrap && this.configuration.WrapAttVals) {
                wrappable = true;
            }
        }
        if (indent + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
            this.addC(32, this.linelen++);
        } else {
            this.condFlushLine(fout, indent);
            this.addC(32, this.linelen++);
        }
        for (int i = 0; i < name.length(); ++i) {
            this.addC(Lexer.foldCase(name.charAt(i), this.configuration.UpperCaseAttrs, this.configuration.XmlTags), this.linelen++);
        }
        if (indent + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(fout, indent);
        }
        if (attr.value == null) {
            if (this.configuration.XmlTags || this.configuration.XmlOut) {
                this.printAttrValue(fout, indent, attr.attribute, attr.delim, true);
            } else if (!attr.isBoolAttribute() && !Node.isNewNode(node)) {
                this.printAttrValue(fout, indent, "", attr.delim, true);
            } else if (indent + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
        } else {
            this.printAttrValue(fout, indent, attr.value, attr.delim, wrappable);
        }
    }

    private void printAttrs(Out fout, int indent, Node node, AttVal attr) {
        if (attr != null) {
            if (attr.next != null) {
                this.printAttrs(fout, indent, node, attr.next);
            }
            if (attr.attribute != null) {
                this.printAttribute(fout, indent, node, attr);
            } else if (attr.asp != null) {
                this.addC(32, this.linelen++);
                this.printAsp(fout, indent, attr.asp);
            } else if (attr.php != null) {
                this.addC(32, this.linelen++);
                this.printPhp(fout, indent, attr.php);
            }
        }
        if (this.configuration.XmlOut && this.configuration.XmlSpace && ParserImpl.XMLPreserveWhiteSpace(node, this.configuration.tt) && node.getAttrByName("xml:space") == null) {
            this.printString(fout, indent, " xml:space=\"preserve\"");
        }
    }

    private static boolean afterSpace(Node node) {
        if (node == null || node.tag == null || (node.tag.model & 0x10) == 0) {
            return true;
        }
        Node prev = node.prev;
        if (prev != null) {
            int c;
            return prev.type == 4 && prev.end > prev.start && ((c = prev.textarray[prev.end - 1] & 0xFF) == 160 || c == 32 || c == 10);
        }
        return PPrint.afterSpace(node.parent);
    }

    private void printTag(Lexer lexer, Out fout, short mode, int indent, Node node) {
        TagTable tt = this.configuration.tt;
        this.addC(60, this.linelen++);
        if (node.type == 6) {
            this.addC(47, this.linelen++);
        }
        String p = node.element;
        for (int i = 0; i < p.length(); ++i) {
            this.addC(Lexer.foldCase(p.charAt(i), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        }
        this.printAttrs(fout, indent, node, node.attributes);
        if ((this.configuration.XmlOut || lexer != null && lexer.isvoyager) && (node.type == 7 || (node.tag.model & 1) != 0)) {
            this.addC(32, this.linelen++);
            this.addC(47, this.linelen++);
        }
        this.addC(62, this.linelen++);
        if (node.type != 7 && (mode & 1) == 0) {
            if (indent + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(fout, indent);
            }
            if (indent + this.linelen < this.configuration.wraplen) {
                if (PPrint.afterSpace(node) && (mode & 8) == 0 && ((node.tag.model & 0x10) == 0 || node.tag == tt.tagBr || (node.tag.model & 1) != 0 && node.next == null && node.parent.tag == tt.tagA)) {
                    this.wraphere = this.linelen;
                }
            } else {
                this.condFlushLine(fout, indent);
            }
        }
    }

    private void printEndTag(Out fout, short mode, int indent, Node node) {
        this.addC(60, this.linelen++);
        this.addC(47, this.linelen++);
        String p = node.element;
        for (int i = 0; i < p.length(); ++i) {
            this.addC(Lexer.foldCase(p.charAt(i), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        }
        this.addC(62, this.linelen++);
    }

    private void printComment(Out fout, int indent, Node node) {
        if (indent + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.printText(fout, (short)2, indent, node.textarray, node.start, node.end);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(62, this.linelen++);
        if (node.linebreak) {
            this.flushLine(fout, indent);
        }
    }

    private void printDocType(Out fout, int indent, Node node) {
        boolean q = this.configuration.QuoteMarks;
        this.configuration.QuoteMarks = false;
        if (indent + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.condFlushLine(fout, indent);
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(79, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(89, this.linelen++);
        this.addC(80, this.linelen++);
        this.addC(69, this.linelen++);
        this.addC(32, this.linelen++);
        if (indent + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.printText(fout, (short)0, indent, node.textarray, node.start, node.end);
        if (this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(62, this.linelen++);
        this.configuration.QuoteMarks = q;
        this.condFlushLine(fout, indent);
    }

    private void printPI(Out fout, int indent, Node node) {
        if (indent + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(fout, (short)16, indent, node.textarray, node.start, node.end);
        if (node.textarray[node.end - 1] != 63) {
            this.addC(63, this.linelen++);
        }
        this.addC(62, this.linelen++);
        this.condFlushLine(fout, indent);
    }

    private void printAsp(Out fout, int indent, Node node) {
        int savewraplen = this.configuration.wraplen;
        if (!this.configuration.WrapAsp || !this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(37, this.linelen++);
        this.printText(fout, this.configuration.WrapAsp ? (short)16 : 2, indent, node.textarray, node.start, node.end);
        this.addC(37, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = savewraplen;
    }

    private void printJste(Out fout, int indent, Node node) {
        int savewraplen = this.configuration.wraplen;
        if (!this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(35, this.linelen++);
        this.printText(fout, this.configuration.WrapJste ? (short)16 : 2, indent, node.textarray, node.start, node.end);
        this.addC(35, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = savewraplen;
    }

    private void printPhp(Out fout, int indent, Node node) {
        int savewraplen = this.configuration.wraplen;
        if (!this.configuration.WrapPhp) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(fout, this.configuration.WrapPhp ? (short)16 : 2, indent, node.textarray, node.start, node.end);
        this.addC(63, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = savewraplen;
    }

    private void printCDATA(Out fout, int indent, Node node) {
        int savewraplen = this.configuration.wraplen;
        this.condFlushLine(fout, indent);
        this.configuration.wraplen = 0xFFFFFF;
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(fout, (short)2, indent, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.condFlushLine(fout, indent);
        this.configuration.wraplen = savewraplen;
    }

    private void printSection(Out fout, int indent, Node node) {
        int savewraplen = this.configuration.wraplen;
        if (!this.configuration.WrapSection) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(fout, this.configuration.WrapSection ? (short)16 : 2, indent, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = savewraplen;
    }

    private boolean shouldIndent(Node node) {
        TagTable tt = this.configuration.tt;
        if (!this.configuration.IndentContent) {
            return false;
        }
        if (this.configuration.SmartIndent) {
            if (node.content != null && (node.tag.model & 0x40000) != 0) {
                node = node.content;
                while (node != null) {
                    if (node.tag != null && (node.tag.model & 8) != 0) {
                        return true;
                    }
                    node = node.next;
                }
                return false;
            }
            if ((node.tag.model & 0x4000) != 0) {
                return false;
            }
            if (node.tag == tt.tagP) {
                return false;
            }
            if (node.tag == tt.tagTitle) {
                return false;
            }
        }
        if ((node.tag.model & 0xC00) != 0) {
            return true;
        }
        if (node.tag == tt.tagMap) {
            return true;
        }
        return (node.tag.model & 0x10) == 0;
    }

    public void printTree(Out fout, short mode, int indent, Lexer lexer, Node node) {
        TagTable tt = this.configuration.tt;
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(fout, mode, indent, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.printComment(fout, indent, node);
        } else if (node.type == 0) {
            Node content = node.content;
            while (content != null) {
                this.printTree(fout, mode, indent, lexer, content);
                content = content.next;
            }
        } else if (node.type == 1) {
            this.printDocType(fout, indent, node);
        } else if (node.type == 3) {
            this.printPI(fout, indent, node);
        } else if (node.type == 8) {
            this.printCDATA(fout, indent, node);
        } else if (node.type == 9) {
            this.printSection(fout, indent, node);
        } else if (node.type == 10) {
            this.printAsp(fout, indent, node);
        } else if (node.type == 11) {
            this.printJste(fout, indent, node);
        } else if (node.type == 12) {
            this.printPhp(fout, indent, node);
        } else if ((node.tag.model & 1) != 0 || node.type == 7) {
            if ((node.tag.model & 0x10) == 0) {
                this.condFlushLine(fout, indent);
            }
            if (node.tag == tt.tagBr && node.prev != null && node.prev.tag != tt.tagBr && this.configuration.BreakBeforeBR) {
                this.flushLine(fout, indent);
            }
            if (this.configuration.MakeClean && node.tag == tt.tagWbr) {
                this.printString(fout, indent, " ");
            } else {
                this.printTag(lexer, fout, mode, indent, node);
            }
            if (node.tag == tt.tagParam || node.tag == tt.tagArea) {
                this.condFlushLine(fout, indent);
            } else if (node.tag == tt.tagBr || node.tag == tt.tagHr) {
                this.flushLine(fout, indent);
            }
        } else if (node.tag != null && node.tag.parser == ParserImpl.getParsePre()) {
            this.condFlushLine(fout, indent);
            indent = 0;
            this.condFlushLine(fout, indent);
            this.printTag(lexer, fout, mode, indent, node);
            this.flushLine(fout, indent);
            Node content = node.content;
            while (content != null) {
                this.printTree(fout, (short)(mode | 1 | 8), indent, lexer, content);
                content = content.next;
            }
            this.condFlushLine(fout, indent);
            this.printEndTag(fout, mode, indent, node);
            this.flushLine(fout, indent);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(fout, indent);
            }
        } else if (node.tag == tt.tagStyle || node.tag == tt.tagScript) {
            this.condFlushLine(fout, indent);
            indent = 0;
            this.condFlushLine(fout, indent);
            this.printTag(lexer, fout, mode, indent, node);
            this.flushLine(fout, indent);
            Node content = node.content;
            while (content != null) {
                this.printTree(fout, (short)(mode | 1 | 8 | 0x10), indent, lexer, content);
                content = content.next;
            }
            this.condFlushLine(fout, indent);
            this.printEndTag(fout, mode, indent, node);
            this.flushLine(fout, indent);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(fout, indent);
            }
        } else if ((node.tag.model & 0x10) != 0) {
            if (this.configuration.MakeClean) {
                if (node.tag == tt.tagFont) {
                    Node content = node.content;
                    while (content != null) {
                        this.printTree(fout, mode, indent, lexer, content);
                        content = content.next;
                    }
                    return;
                }
                if (node.tag == tt.tagNobr) {
                    Node content = node.content;
                    while (content != null) {
                        this.printTree(fout, (short)(mode | 8), indent, lexer, content);
                        content = content.next;
                    }
                    return;
                }
            }
            this.printTag(lexer, fout, mode, indent, node);
            if (this.shouldIndent(node)) {
                this.condFlushLine(fout, indent);
                indent += this.configuration.spaces;
                Node content = node.content;
                while (content != null) {
                    this.printTree(fout, mode, indent, lexer, content);
                    content = content.next;
                }
                this.condFlushLine(fout, indent);
                this.condFlushLine(fout, indent -= this.configuration.spaces);
            } else {
                Node content = node.content;
                while (content != null) {
                    this.printTree(fout, mode, indent, lexer, content);
                    content = content.next;
                }
            }
            this.printEndTag(fout, mode, indent, node);
        } else {
            this.condFlushLine(fout, indent);
            if (this.configuration.SmartIndent && node.prev != null) {
                this.flushLine(fout, indent);
            }
            if (!this.configuration.HideEndTags || node.tag == null || (node.tag.model & 0x200000) == 0) {
                this.printTag(lexer, fout, mode, indent, node);
                if (this.shouldIndent(node)) {
                    this.condFlushLine(fout, indent);
                } else if ((node.tag.model & 2) != 0 || node.tag == tt.tagNoframes || (node.tag.model & 4) != 0 && node.tag != tt.tagTitle) {
                    this.flushLine(fout, indent);
                }
            }
            if (node.tag == tt.tagBody && this.configuration.BurstSlides) {
                this.printSlide(fout, mode, this.configuration.IndentContent ? indent + this.configuration.spaces : indent, lexer);
            } else {
                Node last = null;
                Node content = node.content;
                while (content != null) {
                    if (last != null && !this.configuration.IndentContent && last.type == 4 && content.tag != null && (content.tag.model & 8) != 0) {
                        this.flushLine(fout, indent);
                        this.flushLine(fout, indent);
                    }
                    this.printTree(fout, mode, this.shouldIndent(node) ? indent + this.configuration.spaces : indent, lexer, content);
                    last = content;
                    content = content.next;
                }
            }
            if (this.shouldIndent(node) || ((node.tag.model & 2) != 0 || node.tag == tt.tagNoframes || (node.tag.model & 4) != 0 && node.tag != tt.tagTitle) && !this.configuration.HideEndTags) {
                this.condFlushLine(fout, this.configuration.IndentContent ? indent + this.configuration.spaces : indent);
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(fout, mode, indent, node);
                    this.flushLine(fout, indent);
                }
            } else {
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(fout, mode, indent, node);
                }
                this.flushLine(fout, indent);
            }
            if (!this.configuration.IndentContent && node.next != null && !this.configuration.HideEndTags && (node.tag.model & 0xE8) != 0) {
                this.flushLine(fout, indent);
            }
        }
    }

    public void printXMLTree(Out fout, short mode, int indent, Lexer lexer, Node node) {
        TagTable tt = this.configuration.tt;
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(fout, mode, indent, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.condFlushLine(fout, indent);
            this.printComment(fout, 0, node);
            this.condFlushLine(fout, 0);
        } else if (node.type == 0) {
            Node content = node.content;
            while (content != null) {
                this.printXMLTree(fout, mode, indent, lexer, content);
                content = content.next;
            }
        } else if (node.type == 1) {
            this.printDocType(fout, indent, node);
        } else if (node.type == 3) {
            this.printPI(fout, indent, node);
        } else if (node.type == 9) {
            this.printSection(fout, indent, node);
        } else if (node.type == 10) {
            this.printAsp(fout, indent, node);
        } else if (node.type == 11) {
            this.printJste(fout, indent, node);
        } else if (node.type == 12) {
            this.printPhp(fout, indent, node);
        } else if ((node.tag.model & 1) != 0 || node.type == 7) {
            this.condFlushLine(fout, indent);
            this.printTag(lexer, fout, mode, indent, node);
            this.flushLine(fout, indent);
            if (node.next != null) {
                this.flushLine(fout, indent);
            }
        } else {
            int cindent;
            boolean mixed = false;
            Node content = node.content;
            while (content != null) {
                if (content.type == 4) {
                    mixed = true;
                    break;
                }
                content = content.next;
            }
            this.condFlushLine(fout, indent);
            if (ParserImpl.XMLPreserveWhiteSpace(node, tt)) {
                indent = 0;
                cindent = 0;
                mixed = false;
            } else {
                cindent = mixed ? indent : indent + this.configuration.spaces;
            }
            this.printTag(lexer, fout, mode, indent, node);
            if (!mixed) {
                this.flushLine(fout, indent);
            }
            content = node.content;
            while (content != null) {
                this.printXMLTree(fout, mode, cindent, lexer, content);
                content = content.next;
            }
            if (!mixed) {
                this.condFlushLine(fout, cindent);
            }
            this.printEndTag(fout, mode, indent, node);
            this.condFlushLine(fout, indent);
            if (node.next != null) {
                this.flushLine(fout, indent);
            }
        }
    }

    public int countSlides(Node node) {
        int n = 1;
        TagTable tt = this.configuration.tt;
        node = node.content;
        while (node != null) {
            if (node.tag == tt.tagH2) {
                ++n;
            }
            node = node.next;
        }
        return n;
    }

    private void printVertSpacer(Out fout, int indent) {
        this.condFlushLine(fout, indent);
        this.printString(fout, indent, "<img width=\"0\" height=\"0\" hspace=\"1\" src=\"dot.gif\" vspace=\"%d\" align=\"left\">");
        this.condFlushLine(fout, indent);
    }

    private void printNavBar(Out fout, int indent) {
        String buf;
        this.condFlushLine(fout, indent);
        this.printString(fout, indent, "<center><small>");
        if (this.slide > 1) {
            buf = "<a href=\"slide" + new Integer(this.slide - 1).toString() + ".html\">previous</a> | ";
            this.printString(fout, indent, buf);
            this.condFlushLine(fout, indent);
            if (this.slide < this.count) {
                this.printString(fout, indent, "<a href=\"slide1.html\">start</a> | ");
            } else {
                this.printString(fout, indent, "<a href=\"slide1.html\">start</a>");
            }
            this.condFlushLine(fout, indent);
        }
        if (this.slide < this.count) {
            buf = "<a href=\"slide" + new Integer(this.slide + 1).toString() + ".html\">next</a>";
            this.printString(fout, indent, buf);
        }
        this.printString(fout, indent, "</small></center>");
        this.condFlushLine(fout, indent);
    }

    public void printSlide(Out fout, short mode, int indent, Lexer lexer) {
        TagTable tt = this.configuration.tt;
        String s = "<div onclick=\"document.location='slide" + new Integer(this.slide < this.count ? this.slide + 1 : 1).toString() + ".html'\">";
        this.printString(fout, indent, s);
        this.condFlushLine(fout, indent);
        if (this.slidecontent.tag == tt.tagH2) {
            this.printNavBar(fout, indent);
            this.addC(60, this.linelen++);
            this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            if (this.configuration.XmlOut) {
                this.printString(fout, indent, " />");
            } else {
                this.addC(62, this.linelen++);
            }
            if (this.configuration.IndentContent) {
                this.condFlushLine(fout, indent);
            }
            this.printTree(fout, mode, this.configuration.IndentContent ? indent + this.configuration.spaces : indent, lexer, this.slidecontent);
            this.slidecontent = this.slidecontent.next;
        }
        Node last = null;
        Node content = this.slidecontent;
        while (content != null && content.tag != tt.tagH2) {
            if (last != null && !this.configuration.IndentContent && last.type == 4 && content.tag != null && (content.tag.model & 8) != 0) {
                this.flushLine(fout, indent);
                this.flushLine(fout, indent);
            }
            this.printTree(fout, mode, this.configuration.IndentContent ? indent + this.configuration.spaces : indent, lexer, content);
            last = content;
            content = content.next;
        }
        this.slidecontent = content;
        this.condFlushLine(fout, indent);
        this.printString(fout, indent, "<br clear=\"all\">");
        this.condFlushLine(fout, indent);
        this.addC(60, this.linelen++);
        this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        if (this.configuration.XmlOut) {
            this.printString(fout, indent, " />");
        } else {
            this.addC(62, this.linelen++);
        }
        if (this.configuration.IndentContent) {
            this.condFlushLine(fout, indent);
        }
        this.printNavBar(fout, indent);
        this.printString(fout, indent, "</div>");
        this.condFlushLine(fout, indent);
    }

    public void addTransitionEffect(Lexer lexer, Node root, short effect, double duration) {
        Node head = root.findHEAD(lexer.configuration.tt);
        String transition = 0 <= effect && effect <= 23 ? "revealTrans(Duration=" + new Double(duration).toString() + ",Transition=" + effect + ")" : "blendTrans(Duration=" + new Double(duration).toString() + ")";
        if (head != null) {
            Node meta = lexer.inferredTag("meta");
            meta.addAttribute("http-equiv", "Page-Enter");
            meta.addAttribute("content", transition);
            Node.insertNodeAtStart(head, meta);
        }
    }

    public void createSlides(Lexer lexer, Node root) {
        String buf;
        OutImpl out = new OutImpl();
        Node body = root.findBody(lexer.configuration.tt);
        this.count = this.countSlides(body);
        this.slidecontent = body.content;
        this.addTransitionEffect(lexer, root, (short)-1, 3.0);
        this.slide = 1;
        while (this.slide <= this.count) {
            buf = "slide" + this.slide + ".html";
            out.state = 0;
            out.encoding = this.configuration.CharEncoding;
            try {
                out.out = new FileOutputStream(buf);
                this.printTree(out, (short)0, 0, lexer, root);
                this.flushLine(out, 0);
                out.out.close();
            }
            catch (IOException e) {
                System.err.println(buf + e.toString());
            }
            ++this.slide;
        }
        while (new File(buf = "slide" + this.slide + "html").delete()) {
            ++this.slide;
        }
    }
}

