/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class StringUtil {
    private static final OutputStream DUMMY_OUTPUT_STREAM = new ByteArrayOutputStream(0);
    private static final String SYSTEM_CHARSET = new OutputStreamWriter(DUMMY_OUTPUT_STREAM).getEncoding();

    public static String getMessage(ResourceBundle bundle, Object key, Object[] params) {
        String pattern = bundle.getString(key.toString());
        if (params == null || params.length == 0) {
            return pattern;
        }
        return MessageFormat.format(pattern, params);
    }

    public static String getMessage(ResourceBundle bundle, Object key, Object param1) {
        return StringUtil.getMessage(bundle, key, new Object[]{param1});
    }

    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2) {
        return StringUtil.getMessage(bundle, key, new Object[]{param1, param2});
    }

    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2, Object param3) {
        return StringUtil.getMessage(bundle, key, new Object[]{param1, param2, param3});
    }

    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2, Object param3, Object param4) {
        return StringUtil.getMessage(bundle, key, new Object[]{param1, param2, param3, param4});
    }

    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return StringUtil.getMessage(bundle, key, new Object[]{param1, param2, param3, param4, param5});
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getSystemCharset() {
        return SYSTEM_CHARSET;
    }

    public static String getCanonicalCharset(String charset) throws UnsupportedEncodingException {
        return new OutputStreamWriter(DUMMY_OUTPUT_STREAM, charset).getEncoding();
    }

    public static String getCanonicalCharsetQuiet(String charset) {
        try {
            return StringUtil.getCanonicalCharset(charset);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String expendProperty(String value) {
        return StringUtil.expendProperty(value, System.getProperties());
    }

    public static String expendProperty(String value, Map properties) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf("${", 0);
        if (i == -1) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value.length());
        int length = value.length();
        int j = 0;
        while (i < length) {
            int k;
            if (i > j) {
                buffer.append(value.substring(j, i));
                j = i;
            }
            for (k = i + 2; k < length && value.charAt(k) != '}'; ++k) {
            }
            if (k == length) {
                buffer.append(value.substring(i, k));
                break;
            }
            String propertyName = value.substring(i + 2, k);
            if (propertyName.equals("/")) {
                buffer.append(File.separatorChar);
            } else {
                Object propertyValue = properties.get(propertyName);
                if (propertyValue != null) {
                    buffer.append(propertyValue);
                } else {
                    buffer.append("${").append(propertyName).append("}");
                }
            }
            if ((i = value.indexOf("${", j = k + 1)) != -1) continue;
            if (j >= length) break;
            buffer.append(value.substring(j, length));
            break;
        }
        return buffer.toString();
    }

    public static List splitStr(String sStr, String sSplitter) {
        if (sStr == null || sStr.length() <= 0 || sSplitter == null || sSplitter.length() <= 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(sStr, sSplitter);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static boolean isNum(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        char[] ch = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(ch[i])) continue;
            return false;
        }
        return true;
    }
}

