/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.configuration.digester;

import com.alibaba.toolkit.util.configuration.digester.ContextSensitiveRule;
import com.alibaba.toolkit.util.configuration.digester.SetContextRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;

public class ContextSensitiveRules
implements Rules {
    private static final String CONTEXT_INITIALIZING = "INITIALIZING";
    private static final String CONTEXT_INITIALIZED = "INITIALIZED";
    protected Rules rules;
    private String context = "";
    private StringBuffer contextBuffer = new StringBuffer();
    private Map contextStatus = new HashMap();

    public ContextSensitiveRules() {
        this(new RulesBase());
    }

    public ContextSensitiveRules(Rules rules) {
        this.rules = rules;
    }

    public void pushContext(String context) {
        this.contextBuffer.append('/').append(context);
        this.context = this.contextBuffer.toString();
    }

    public String popContext() {
        int index = this.context.lastIndexOf("/");
        String topContext = null;
        if (index >= 0) {
            topContext = this.contextBuffer.substring(index + 1, this.contextBuffer.length());
            this.contextBuffer.setLength(index);
        }
        this.context = this.contextBuffer.toString();
        return topContext;
    }

    public boolean isInitialized(String context) {
        return CONTEXT_INITIALIZED.equals(this.contextStatus.get(context));
    }

    public void setInitializing(String context) {
        this.contextStatus.put(context, CONTEXT_INITIALIZING);
    }

    public void setInitialized(String context) {
        this.contextStatus.put(context, CONTEXT_INITIALIZED);
    }

    public String getContext() {
        return this.context;
    }

    public Digester getDigester() {
        return this.rules.getDigester();
    }

    public void setDigester(Digester digester) {
        this.rules.setDigester(digester);
    }

    public String getNamespaceURI() {
        return this.rules.getNamespaceURI();
    }

    public void setNamespaceURI(String namespaceURI) {
        this.rules.setNamespaceURI(namespaceURI);
    }

    public void add(String pattern, Rule rule) {
        if (this.context.length() > 0 && !(rule instanceof SetContextRule) && CONTEXT_INITIALIZING.equals(this.contextStatus.get(this.context))) {
            rule = new ContextSensitiveRule(rule, this.context);
        }
        this.rules.add(pattern, rule);
    }

    public void clear() {
        this.rules.clear();
    }

    @Deprecated
    public List match(String pattern) {
        return this.match(null, pattern);
    }

    public List match(String namespaceURI, String pattern) {
        List<Rule> list = this.rules.match(namespaceURI, pattern);
        ArrayList<Rule> sublist = new ArrayList<Rule>(list.size());
        for (Rule rule : list) {
            if (rule instanceof ContextSensitiveRule && !((ContextSensitiveRule)rule).isContextMatched(this.context)) continue;
            sublist.add(rule);
        }
        return sublist;
    }

    public List rules() {
        return this.rules.rules();
    }

    public String toString() {
        return this.rules.toString();
    }
}

