/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle;

import com.alibaba.toolkit.util.StringUtil;
import com.alibaba.toolkit.util.resourcebundle.MessageBuilder;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ResourceBundle
extends java.util.ResourceBundle {
    private String baseName;
    private Locale locale;

    public String getBaseName() {
        return this.baseName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MessageBuilder getMessageBuilder(Object key) {
        return new MessageBuilder(this, key);
    }

    public final String getMessage(Object key, Object[] params) {
        return StringUtil.getMessage((java.util.ResourceBundle)this, key, params);
    }

    public final String getString(Object key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(Object key) {
        return (String[])this.getObject(key);
    }

    public final Map getMap(Object key) {
        return (Map)this.getObject(key);
    }

    public final List getList(Object key) {
        return (List)this.getObject(key);
    }

    public final Object getObject(Object key) {
        return super.getObject(key.toString());
    }

    protected final void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    protected final void setLocale(String baseName, String bundleName) {
        if (baseName.length() == bundleName.length()) {
            this.locale = new Locale("", "");
        } else if (baseName.length() < bundleName.length()) {
            int pos = baseName.length();
            String temp = bundleName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                this.locale = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            this.locale = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("The basename \"{0}\" is longer than the bundle name \"{1}\"", baseName, bundleName));
        }
    }

    protected final void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    protected final java.util.ResourceBundle getParent() {
        return this.parent;
    }
}

