/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api;

import java.io.Serializable;
import java.util.Properties;

public class Message
implements Serializable {
    private static final long serialVersionUID = -1385924226856188094L;
    private String topic;
    Properties systemProperties;
    private Properties userProperties;
    private byte[] body;

    public Message() {
        this(null, null, "", null);
    }

    public Message(String topic, String tags, byte[] body) {
        this(topic, tags, "", body);
    }

    public Message(String topic, String tag, String key, byte[] body) {
        this.topic = topic;
        this.body = body;
        this.putSystemProperties("__TAG", tag);
        this.putSystemProperties("__KEY", key);
    }

    void putSystemProperties(String key, String value) {
        if (null == this.systemProperties) {
            this.systemProperties = new Properties();
        }
        if (key != null && value != null) {
            this.systemProperties.put(key, value);
        }
    }

    String getSystemProperties(String key) {
        if (null != this.systemProperties) {
            return this.systemProperties.getProperty(key);
        }
        return null;
    }

    public void putUserProperties(String key, String value) {
        if (null == this.userProperties) {
            this.userProperties = new Properties();
        }
        if (key != null && value != null) {
            this.userProperties.put(key, value);
        }
    }

    public String getUserProperties(String key) {
        if (null != this.userProperties) {
            return (String)this.userProperties.get(key);
        }
        return null;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.getSystemProperties("__TAG");
    }

    public void setTag(String tag) {
        this.putSystemProperties("__TAG", tag);
    }

    public String getKey() {
        return this.getSystemProperties("__KEY");
    }

    public void setKey(String key) {
        this.putSystemProperties("__KEY", key);
    }

    public String getMsgID() {
        return this.getSystemProperties("__MSGID");
    }

    public void setMsgID(String msgid) {
        this.putSystemProperties("__MSGID", msgid);
    }

    Properties getSystemProperties() {
        return this.systemProperties;
    }

    void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setReconsumeTimes(int value) {
        this.putSystemProperties("__RECONSUMETIMES", String.valueOf(value));
    }

    public int getReconsumeTimes() {
        String pro = this.getSystemProperties("__RECONSUMETIMES");
        if (pro != null) {
            return Integer.parseInt(pro);
        }
        return 0;
    }

    public void setStartDeliverTime(long value) {
        this.putSystemProperties("__STARTDELIVERTIME", String.valueOf(value));
    }

    public long getStartDeliverTime() {
        String pro = this.getSystemProperties("__STARTDELIVERTIME");
        if (pro != null) {
            return Long.parseLong(pro);
        }
        return 0L;
    }

    public String toString() {
        return "Message [topic=" + this.topic + ", systemProperties=" + this.systemProperties + ", userProperties=" + this.userProperties + ", body=" + (this.body != null ? this.body.length : 0) + "]";
    }

    public static class SystemPropKey {
        public static final String TAG = "__TAG";
        public static final String KEY = "__KEY";
        public static final String MSGID = "__MSGID";
        public static final String RECONSUMETIMES = "__RECONSUMETIMES";
        public static final String STARTDELIVERTIME = "__STARTDELIVERTIME";
    }
}

