/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoParser;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaobaoClient
implements TaobaoClient {
    private static final String APP_KEY = "app_key";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "v";
    private static final String SIGN = "sign";
    private static final String SIGN_METHOD = "sign_method";
    private static final String PARTNER_ID = "partner_id";
    private static final String SESSION = "session";
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private String signMethod = "hmac";
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Boolean needCheckRequest = true;

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        TaobaoParser<T> parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, session);
    }

    private <T extends TaobaoResponse> T _execute(TaobaoRequest<T> request, TaobaoParser<T> parser, String session) throws ApiException {
        Map<String, Object> rt;
        if (this.needCheckRequest.booleanValue()) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                TaobaoResponse localResponse = null;
                try {
                    localResponse = (TaobaoResponse)request.getResponseClass().newInstance();
                }
                catch (InstantiationException e2) {
                    throw new ApiException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new ApiException(e3);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        if ((rt = this.doPost(request, session)) == null) {
            return null;
        }
        TaobaoResponse tRsp = null;
        try {
            tRsp = (TaobaoResponse)parser.parse((String)rt.get("rsp"));
            tRsp.setBody((String)rt.get("rsp"));
        }
        catch (RuntimeException e) {
            TaobaoLogger.logBizError((String)rt.get("rsp"));
            throw e;
        }
        tRsp.setParams((TaobaoHashMap)rt.get("textParams"));
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logErrorScene(rt, tRsp, this.appSecret);
        }
        return (T)tRsp;
    }

    private <T extends TaobaoResponse> Map<String, Object> doPost(TaobaoRequest<T> request, String session) throws ApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put(METHOD, request.getApiMethodName());
        protocalMustParams.put(VERSION, "2.0");
        protocalMustParams.put(APP_KEY, this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        this.df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put(TIMESTAMP, this.df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put(FORMAT, this.format);
        protocalOptParams.put(SIGN_METHOD, this.signMethod);
        protocalOptParams.put(SESSION, session);
        protocalOptParams.put(PARTNER_ID, "top-sdk-java-20120515");
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if ("md5".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, false));
            } else if ("hmac".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, true));
            } else {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequest(requestHolder, this.appSecret));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            if (request instanceof TaobaoUploadRequest) {
                TaobaoUploadRequest uRequest = (TaobaoUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(urlSb.toString(), (Map<String, String>)appParams, fileParams, this.connectTimeout, this.readTimeout);
            } else {
                rsp = WebUtils.doPost(urlSb.toString(), appParams, this.connectTimeout, this.readTimeout);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        result.put("rsp", rsp);
        result.put("textParams", appParams);
        result.put("protocalMustParams", protocalMustParams);
        result.put("protocalOptParams", protocalOptParams);
        result.put("url", urlSb.toString());
        return result;
    }

    public Boolean getNeedCheckRequest() {
        return this.needCheckRequest;
    }

    public void setNeedCheckRequest(Boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }
}

