/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.stream;

import com.taobao.api.internal.stream.connect.ConnectionLifeCycleListener;
import com.taobao.api.internal.stream.message.TopCometMessageListener;
import com.taobao.api.internal.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TopCometStreamRequest {
    private String appkey;
    private String secret;
    private String userId;
    private String connectId;
    private ConnectionLifeCycleListener connectListener;
    private TopCometMessageListener msgListener;

    public TopCometStreamRequest(String appkey, String secret, String userId, String connectId) {
        if (StringUtils.isEmpty(appkey)) {
            throw new RuntimeException("appkey is null");
        }
        if (StringUtils.isEmpty(secret)) {
            throw new RuntimeException("secret is null");
        }
        if (!StringUtils.isEmpty(userId)) {
            try {
                Long.parseLong(userId);
            }
            catch (Exception e) {
                throw new RuntimeException("userid must a number type");
            }
        }
        this.connectId = StringUtils.isEmpty(connectId) ? TopCometStreamRequest.getDefaultConnectId() : connectId;
        this.appkey = appkey;
        this.secret = secret;
        this.userId = userId;
    }

    private static String getDefaultConnectId() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConnectId() {
        return this.connectId;
    }

    public ConnectionLifeCycleListener getConnectListener() {
        return this.connectListener;
    }

    public void setConnectListener(ConnectionLifeCycleListener connectListener) {
        this.connectListener = connectListener;
    }

    public TopCometMessageListener getMsgListener() {
        return this.msgListener;
    }

    public void setMsgListener(TopCometMessageListener msgListener) {
        this.msgListener = msgListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appkey == null ? 0 : this.appkey.hashCode());
        result = 31 * result + (this.connectId == null ? 0 : this.connectId.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopCometStreamRequest other = (TopCometStreamRequest)obj;
        if (this.appkey == null ? other.appkey != null : !this.appkey.equals(other.appkey)) {
            return false;
        }
        if (this.connectId == null ? other.connectId != null : !this.connectId.equals(other.connectId)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

