/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.stream.connect;

import com.taobao.api.internal.stream.Configuration;
import com.taobao.api.internal.stream.TopCometSysErrorException;
import com.taobao.api.internal.stream.connect.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static final Logger log = Logger.getLogger(HttpClient.class);
    private static boolean isJDK14orEarlier = false;
    private Map<String, String> params;
    private Configuration conf;

    public HttpClient(Configuration conf, Map<String, String> params) {
        if (conf == null || params == null) {
            throw new RuntimeException("conf and params is must not null");
        }
        this.conf = conf;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public HttpResponse post() throws TopCometSysErrorException {
        int retry = this.conf.getHttpConnectRetryCount() + 1;
        HttpResponse resp = null;
        for (int retriedCount = 1; retriedCount <= retry; ++retriedCount) {
            block34: {
                int responseCode = -1;
                try {
                    HttpURLConnection con = null;
                    OutputStream out = null;
                    try {
                        con = this.getConnection(this.conf.getConnectUrl(), this.conf.getHttpConnectionTimeout(), this.conf.getHttpReadTimeout());
                        con.setDoInput(true);
                        con.setDoOutput(true);
                        this.setHeaders(con, this.conf.getRequestHeader());
                        con.setRequestMethod("POST");
                        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        String postParam = this.encodeParameters(this.params);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Post param is:" + postParam));
                        }
                        byte[] bytes = postParam.getBytes("UTF-8");
                        con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                        out = con.getOutputStream();
                        out.write(bytes);
                        out.flush();
                        responseCode = con.getResponseCode();
                        if (200 == responseCode) {
                            Object respHeader;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"connect successful");
                                respHeader = new StringBuilder();
                                Map<String, List<String>> responseHeaders = con.getHeaderFields();
                                for (String key : responseHeaders.keySet()) {
                                    List<String> values = responseHeaders.get(key);
                                    for (String value : values) {
                                        if (key != null) {
                                            ((StringBuilder)respHeader).append(key).append("=").append(value);
                                        } else {
                                            ((StringBuilder)respHeader).append(value);
                                        }
                                        ((StringBuilder)respHeader).append(";");
                                    }
                                }
                                log.debug((Object)("Response: " + ((StringBuilder)respHeader).toString()));
                            }
                            resp = new HttpResponse(con);
                            respHeader = resp;
                            return respHeader;
                        }
                        if (400 == responseCode) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Request param is invalid,errmsg is:" + con.getHeaderField("errmsg")));
                            }
                            throw new TopCometSysErrorException("Server response err msg:" + con.getHeaderField("errmsg"));
                        }
                        if (403 == responseCode) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Server is deploying,sleep " + retriedCount * this.conf.getHttpConnectRetryInterval() + " seconds"));
                            }
                            if (retriedCount == this.conf.getHttpConnectRetryCount()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"May be server occure some error,please contact top tech support");
                                }
                                throw new TopCometSysErrorException("May be server occure some error,please contact top tech support");
                            }
                            try {
                                Thread.sleep(retriedCount * this.conf.getHttpConnectRetryInterval() * 1000);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    finally {
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception ignore) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.conf.getHttpConnectRetryCount()) break block34;
                    throw new TopCometSysErrorException(ioe.getMessage(), ioe);
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sleeping " + this.conf.getHttpConnectRetryInterval() + " seconds until the next retry."));
                }
                Thread.sleep(retriedCount * this.conf.getHttpConnectRetryInterval() * 1000);
                continue;
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return resp;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException neverHappen) {
            throw new AssertionError((Object)"will never happen");
        }
    }

    private String encodeParameters(Map<String, String> params) {
        if (null == params || params != null && params.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        int j = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (j != 0) {
                buf.append("&");
            }
            buf.append(HttpClient.encode(e.getKey())).append("=").append(HttpClient.encode(e.getValue()));
            ++j;
        }
        return buf.toString();
    }

    private void setHeaders(HttpURLConnection connection, Map<String, String> reqHeader) {
        if (reqHeader != null && reqHeader.size() > 0) {
            for (Map.Entry<String, String> e : reqHeader.entrySet()) {
                connection.addRequestProperty(e.getKey(), e.getValue());
            }
        }
    }

    private HttpURLConnection getConnection(String url, int connTimeout, int readTimeout) throws IOException {
        HttpURLConnection con = null;
        con = (HttpURLConnection)new URL(url).openConnection();
        if (connTimeout > 0) {
            if (!isJDK14orEarlier) {
                con.setConnectTimeout(connTimeout * 1000);
            } else {
                System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(connTimeout * 1000));
            }
        }
        if (readTimeout > 0) {
            if (!isJDK14orEarlier) {
                con.setReadTimeout(readTimeout * 1000);
            } else {
                System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(readTimeout * 1000));
            }
        }
        con.setInstanceFollowRedirects(false);
        return con;
    }

    static {
        try {
            String versionStr = System.getProperty("java.specification.version");
            if (versionStr != null) {
                isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
            }
        }
        catch (Exception ignore) {
            isJDK14orEarlier = false;
        }
    }
}

