/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.ApiException;
import com.taobao.api.internal.util.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtsUtils {
    private static final String CTYPE_OCTET = "application/octet-stream";
    private static final Pattern REGEX_FILE_NAME = Pattern.compile("attachment;filename=\"([\\w\\-]+)\"");

    private AtsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File ungzip(File gzip, File toDir) throws IOException {
        toDir.mkdirs();
        File out = new File(toDir, gzip.getName());
        GZIPInputStream gin = null;
        FileOutputStream fout = null;
        try {
            FileInputStream fin = new FileInputStream(gzip);
            gin = new GZIPInputStream(fin);
            fout = new FileOutputStream(out);
            AtsUtils.copy(gin, fout);
            gin.close();
            fout.close();
        }
        catch (Throwable throwable) {
            AtsUtils.closeQuietly(gin);
            AtsUtils.closeQuietly(fout);
            throw throwable;
        }
        AtsUtils.closeQuietly(gin);
        AtsUtils.closeQuietly(fout);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unzip(File zip, File toDir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ZipFile zf = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(toDir, entry.getName()).mkdirs();
                continue;
            }
            InputStream input = null;
            FileOutputStream output = null;
            try {
                File f = new File(toDir, entry.getName());
                input = zf.getInputStream(entry);
                output = new FileOutputStream(f);
                AtsUtils.copy(input, output);
                files.add(f);
            }
            catch (Throwable throwable) {
                AtsUtils.closeQuietly(output);
                AtsUtils.closeQuietly(input);
                throw throwable;
            }
            AtsUtils.closeQuietly(output);
            AtsUtils.closeQuietly(input);
        }
        return files;
    }

    public static File download(String url, File toDir) throws ApiException {
        toDir.mkdirs();
        HttpURLConnection conn = null;
        FileOutputStream output = null;
        File file = null;
        try {
            conn = AtsUtils.getConnection(new URL(url));
            String ctype = conn.getContentType();
            if (!CTYPE_OCTET.equals(ctype)) {
                String rsp = WebUtils.getResponseAsString(conn);
                throw new ApiException(rsp);
            }
            String fileName = AtsUtils.getFileName(conn);
            file = new File(toDir, fileName);
            output = new FileOutputStream(file);
            AtsUtils.copy(conn.getInputStream(), output);
        }
        catch (IOException e) {
            try {
                throw new ApiException(e.getMessage());
            }
            catch (Throwable throwable) {
                AtsUtils.closeQuietly(output);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        AtsUtils.closeQuietly(output);
        if (conn != null) {
            conn.disconnect();
        }
        return file;
    }

    private static String getFileName(HttpURLConnection conn) {
        String fileName = conn.getHeaderField("Content-Disposition");
        Matcher matcher = REGEX_FILE_NAME.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/zip;text/html");
        return conn;
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = AtsUtils.copyStream(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

