/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.HotelUpdateResponse;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotelUpdateRequest
implements TaobaoUploadRequest<HotelUpdateResponse> {
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String address;
    private Long city;
    private String country;
    private String decorateTime;
    private String desc;
    private Long district;
    private Boolean domestic;
    private Long hid;
    private String level;
    private String name;
    private String openingTime;
    private String orientation;
    private FileItem pic;
    private Long province;
    private Long rooms;
    private String service;
    private Long storeys;
    private String tel;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setCity(Long city) {
        this.city = city;
    }

    public Long getCity() {
        return this.city;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setDecorateTime(String decorateTime) {
        this.decorateTime = decorateTime;
    }

    public String getDecorateTime() {
        return this.decorateTime;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDistrict(Long district) {
        this.district = district;
    }

    public Long getDistrict() {
        return this.district;
    }

    public void setDomestic(Boolean domestic) {
        this.domestic = domestic;
    }

    public Boolean getDomestic() {
        return this.domestic;
    }

    public void setHid(Long hid) {
        this.hid = hid;
    }

    public Long getHid() {
        return this.hid;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOpeningTime(String openingTime) {
        this.openingTime = openingTime;
    }

    public String getOpeningTime() {
        return this.openingTime;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setPic(FileItem pic) {
        this.pic = pic;
    }

    public FileItem getPic() {
        return this.pic;
    }

    public void setProvince(Long province) {
        this.province = province;
    }

    public Long getProvince() {
        return this.province;
    }

    public void setRooms(Long rooms) {
        this.rooms = rooms;
    }

    public Long getRooms() {
        return this.rooms;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setStoreys(Long storeys) {
        this.storeys = storeys;
    }

    public Long getStoreys() {
        return this.storeys;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getTel() {
        return this.tel;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.hotel.update";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("address", this.address);
        txtParams.put("city", (Object)this.city);
        txtParams.put("country", this.country);
        txtParams.put("decorate_time", this.decorateTime);
        txtParams.put("desc", this.desc);
        txtParams.put("district", (Object)this.district);
        txtParams.put("domestic", (Object)this.domestic);
        txtParams.put("hid", (Object)this.hid);
        txtParams.put("level", this.level);
        txtParams.put("name", this.name);
        txtParams.put("opening_time", this.openingTime);
        txtParams.put("orientation", this.orientation);
        txtParams.put("province", (Object)this.province);
        txtParams.put("rooms", (Object)this.rooms);
        txtParams.put("service", this.service);
        txtParams.put("storeys", (Object)this.storeys);
        txtParams.put("tel", this.tel);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Map<String, FileItem> getFileParams() {
        HashMap<String, FileItem> params = new HashMap<String, FileItem>();
        params.put("pic", this.pic);
        return params;
    }

    @Override
    public Class<HotelUpdateResponse> getResponseClass() {
        return HotelUpdateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMaxLength(this.address, 120, "address");
        RequestCheckUtils.checkMaxValue(this.city, 999999L, "city");
        RequestCheckUtils.checkMinValue(this.city, 0L, "city");
        RequestCheckUtils.checkMaxLength(this.decorateTime, 4, "decorateTime");
        RequestCheckUtils.checkMaxLength(this.desc, 50000, "desc");
        RequestCheckUtils.checkMaxValue(this.district, 999999L, "district");
        RequestCheckUtils.checkMinValue(this.district, 0L, "district");
        RequestCheckUtils.checkNotEmpty(this.hid, "hid");
        RequestCheckUtils.checkMaxLength(this.level, 1, "level");
        RequestCheckUtils.checkMaxLength(this.name, 60, "name");
        RequestCheckUtils.checkMaxLength(this.openingTime, 4, "openingTime");
        RequestCheckUtils.checkMaxLength(this.orientation, 1, "orientation");
        RequestCheckUtils.checkMaxLength(this.pic, 512000, "pic");
        RequestCheckUtils.checkMaxValue(this.province, 999999L, "province");
        RequestCheckUtils.checkMinValue(this.province, 0L, "province");
        RequestCheckUtils.checkMaxValue(this.rooms, 9999L, "rooms");
        RequestCheckUtils.checkMinValue(this.rooms, 0L, "rooms");
        RequestCheckUtils.checkMaxValue(this.storeys, 9999L, "storeys");
        RequestCheckUtils.checkMinValue(this.storeys, 0L, "storeys");
        RequestCheckUtils.checkMaxLength(this.tel, 32, "tel");
    }
}

