/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.visit;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.IHasCSSDeclarations;
import com.helger.css.decl.visit.CSSVisitorForUrl;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSVisitor {
    private static final CSSVisitor s_aInstance = new CSSVisitor();

    private CSSVisitor() {
    }

    public static void visitImportRule(@Nonnull CSSImportRule cSSImportRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onImport(cSSImportRule);
    }

    public static void visitNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onNamespace(cSSNamespaceRule);
    }

    public static void visitAllDeclarations(@Nonnull IHasCSSDeclarations<?> iHasCSSDeclarations, @Nonnull ICSSVisitor iCSSVisitor) {
        for (CSSDeclaration cSSDeclaration : iHasCSSDeclarations.getAllDeclarations()) {
            iCSSVisitor.onDeclaration(cSSDeclaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitStyleRule(@Nonnull CSSStyleRule cSSStyleRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginStyleRule(cSSStyleRule);
        try {
            for (CSSSelector cSSSelector : cSSStyleRule.getAllSelectors()) {
                iCSSVisitor.onStyleRuleSelector(cSSSelector);
            }
            CSSVisitor.visitAllDeclarations(cSSStyleRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndStyleRule(cSSStyleRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitPageRule(@Nonnull CSSPageRule cSSPageRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginPageRule(cSSPageRule);
        try {
            for (ICSSPageRuleMember iCSSPageRuleMember : cSSPageRule.getAllMembers()) {
                if (iCSSPageRuleMember instanceof CSSDeclaration) {
                    iCSSVisitor.onDeclaration((CSSDeclaration)iCSSPageRuleMember);
                    continue;
                }
                CSSPageMarginBlock cSSPageMarginBlock = (CSSPageMarginBlock)iCSSPageRuleMember;
                iCSSVisitor.onBeginPageMarginBlock(cSSPageMarginBlock);
                try {
                    CSSVisitor.visitAllDeclarations(cSSPageMarginBlock, iCSSVisitor);
                }
                finally {
                    iCSSVisitor.onEndPageMarginBlock(cSSPageMarginBlock);
                }
            }
        }
        finally {
            iCSSVisitor.onEndPageRule(cSSPageRule);
        }
    }

    public static void visitFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginFontFaceRule(cSSFontFaceRule);
        try {
            CSSVisitor.visitAllDeclarations(cSSFontFaceRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndFontFaceRule(cSSFontFaceRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitMediaRule(@Nonnull CSSMediaRule cSSMediaRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginMediaRule(cSSMediaRule);
        try {
            for (ICSSTopLevelRule iCSSTopLevelRule : cSSMediaRule.getAllRules()) {
                CSSVisitor.visitTopLevelRule(iCSSTopLevelRule, iCSSVisitor);
            }
        }
        finally {
            iCSSVisitor.onEndMediaRule(cSSMediaRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginKeyframesRule(cSSKeyframesRule);
        try {
            for (CSSKeyframesBlock cSSKeyframesBlock : cSSKeyframesRule.getAllBlocks()) {
                iCSSVisitor.onBeginKeyframesBlock(cSSKeyframesBlock);
                try {
                    CSSVisitor.visitAllDeclarations(cSSKeyframesBlock, iCSSVisitor);
                }
                finally {
                    iCSSVisitor.onEndKeyframesBlock(cSSKeyframesBlock);
                }
            }
        }
        finally {
            iCSSVisitor.onEndKeyframesRule(cSSKeyframesRule);
        }
    }

    public static void visitViewportRule(@Nonnull CSSViewportRule cSSViewportRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginViewportRule(cSSViewportRule);
        try {
            CSSVisitor.visitAllDeclarations(cSSViewportRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndViewportRule(cSSViewportRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginSupportsRule(cSSSupportsRule);
        try {
            for (ICSSTopLevelRule iCSSTopLevelRule : cSSSupportsRule.getAllRules()) {
                CSSVisitor.visitTopLevelRule(iCSSTopLevelRule, iCSSVisitor);
            }
        }
        finally {
            iCSSVisitor.onEndSupportsRule(cSSSupportsRule);
        }
    }

    public static void visitUnknownRule(@Nonnull CSSUnknownRule cSSUnknownRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onUnknownRule(cSSUnknownRule);
    }

    public static void visitTopLevelRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule, @Nonnull ICSSVisitor iCSSVisitor) {
        if (iCSSTopLevelRule instanceof CSSStyleRule) {
            CSSVisitor.visitStyleRule((CSSStyleRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSPageRule) {
            CSSVisitor.visitPageRule((CSSPageRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSFontFaceRule) {
            CSSVisitor.visitFontFaceRule((CSSFontFaceRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSMediaRule) {
            CSSVisitor.visitMediaRule((CSSMediaRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSKeyframesRule) {
            CSSVisitor.visitKeyframesRule((CSSKeyframesRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSViewportRule) {
            CSSVisitor.visitViewportRule((CSSViewportRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSSupportsRule) {
            CSSVisitor.visitSupportsRule((CSSSupportsRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSUnknownRule) {
            CSSVisitor.visitUnknownRule((CSSUnknownRule)iCSSTopLevelRule, iCSSVisitor);
        } else {
            throw new IllegalStateException("Top level rule " + iCSSTopLevelRule + " is unsupported!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull ICSSVisitor iCSSVisitor) {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notNull((Object)iCSSVisitor, (String)"Visitor");
        iCSSVisitor.begin();
        try {
            for (ICSSWriteable iCSSWriteable : cascadingStyleSheet.getAllImportRules()) {
                CSSVisitor.visitImportRule(iCSSWriteable, iCSSVisitor);
            }
            for (ICSSWriteable iCSSWriteable : cascadingStyleSheet.getAllNamespaceRules()) {
                CSSVisitor.visitNamespaceRule((CSSNamespaceRule)iCSSWriteable, iCSSVisitor);
            }
            for (ICSSWriteable iCSSWriteable : cascadingStyleSheet.getAllRules()) {
                CSSVisitor.visitTopLevelRule((ICSSTopLevelRule)iCSSWriteable, iCSSVisitor);
            }
        }
        finally {
            iCSSVisitor.end();
        }
    }

    public static void visitCSSUrl(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        CSSVisitor.visitCSS(cascadingStyleSheet, new CSSVisitorForUrl(iCSSUrlVisitor));
    }

    public static void visitAllDeclarationUrls(@Nonnull IHasCSSDeclarations<?> iHasCSSDeclarations, @Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        CSSVisitor.visitAllDeclarations(iHasCSSDeclarations, new CSSVisitorForUrl(iCSSUrlVisitor));
    }
}

