/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(13),
    UNKNOWNRULE(59),
    UNKNOWNRULEPARAMETERLIST(57),
    UNKNOWNRULEBODY(58),
    STYLERULE(34),
    IMPORTRULE(14),
    PAGERULE(45),
    MEDIARULE(41),
    FONTFACERULE(46),
    SELECTOR(29),
    STYLEDECLARATIONLIST(33),
    STYLEDECLARATION(32),
    NAMESPACEPREFIX(18),
    ELEMENTNAME(19),
    HASH(20),
    CLASS(21),
    PSEUDO(26),
    NEGATION(27),
    ATTRIB(24),
    ATTRIBOPERATOR(22),
    ATTRIBVALUE(23),
    SELECTORCOMBINATOR(28),
    NTH(25),
    PROPERTY(30),
    IMPORTANT(31),
    EXPR(12),
    EXPRTERM(10),
    EXPROPERATOR(11),
    URL(3),
    FUNCTION(4),
    MATH(9),
    MATHSUMOPERATOR(8),
    MATHPRODUCT(7),
    MATHPRODUCTOPERATOR(6),
    MATHUNIT(5),
    MEDIALIST(40),
    MEDIUM(36),
    MEDIAQUERY(39),
    MEDIAMODIFIER(35),
    MEDIAEXPR(38),
    MEDIAFEATURE(37),
    PSEUDOPAGE(-1),
    PAGESELECTOR(42),
    PAGEMARGINSYMBOL(43),
    PAGERULEBLOCK(44),
    KEYFRAMESRULE(50),
    KEYFRAMESIDENTIFIER(47),
    KEYFRAMESSELECTOR(49),
    SINGLEKEYFRAMESELECTOR(48),
    VIEWPORTRULE(51),
    NAMESPACERULE(17),
    NAMESPACERULEPREFIX(15),
    NAMESPACERULEURL(16),
    SUPPORTSRULE(56),
    SUPPORTSCONDITION(55),
    SUPPORTSCONDITIONOPERATOR(54),
    SUPPORTSNEGATION(53),
    SUPPORTSCONDITIONINPARENS(52),
    ERROR_SKIPTO(1);

    private static final Logger s_aLogger;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    public boolean isNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return cSSNode.getNodeType() == this.getParserNodeType(eCSSVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode, eCSSVersion)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode, eCSSVersion);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName(eCSSVersion);
        }
        s_aLogger.warn("Unsupported node type " + cSSNode.getNodeType() + " in version " + (Object)((Object)eCSSVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode, eCSSVersion));
        if (cSSNode.hasText()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, eCSSVersion, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, eCSSVersion, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return ERROR_SKIPTO.isNode(cSSNode, eCSSVersion);
    }

    static {
        s_aLogger = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

