/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.ValidationResult;
import com.mycila.xmltool.XMLErrorHandler;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class Utils {
    private Utils() {
    }

    static String getMessage(Throwable cause) {
        String message = null;
        while (cause != null && (message == null || message.length() == 0)) {
            message = cause.getMessage();
            cause = cause.getCause();
        }
        return message == null ? "no description available" : message;
    }

    static void notEmpty(String name, String value) {
        Utils.notNull(name, value);
        if (value.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    static void notNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ValidationResult validate(Document doc, Source ... schemas) throws IOException, SAXException {
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        Validator validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemas).newValidator();
        try {
            validator.setErrorHandler(errorHandler);
            validator.validate(new DOMSource(doc));
            XMLErrorHandler xMLErrorHandler = errorHandler;
            return xMLErrorHandler;
        }
        finally {
            validator.reset();
        }
    }

    static ValidationResult validate(Document doc, URL ... schemaLocations) throws URISyntaxException, IOException, SAXException {
        Source[] sources = new Source[schemaLocations.length];
        for (int i = 0; i < schemaLocations.length; ++i) {
            sources[i] = new StreamSource(schemaLocations[i].toURI().toASCIIString());
        }
        return Utils.validate(doc, sources);
    }
}

