/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

public interface HystrixThreadPool {
    public ThreadPoolExecutor getExecutor();

    public void markThreadExecution();

    public void markThreadCompletion();

    public boolean isQueueSpaceAvailable();

    @ThreadSafe
    public static class HystrixThreadPoolDefault
    implements HystrixThreadPool {
        private final HystrixThreadPoolProperties properties;
        private final BlockingQueue<Runnable> queue;
        private final ThreadPoolExecutor threadPool;
        private final HystrixThreadPoolMetrics metrics;

        public HystrixThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixConcurrencyStrategy concurrencyStrategy, HystrixMetricsPublisher metricsPublisher, HystrixPropertiesStrategy propertiesFactory, HystrixThreadPoolProperties.Setter propertiesDefaults) {
            this.properties = HystrixPropertiesFactory.getThreadPoolProperties(propertiesFactory, threadPoolKey, propertiesDefaults);
            this.queue = concurrencyStrategy.getBlockingQueue(this.properties.maxQueueSize().get());
            this.threadPool = concurrencyStrategy.getThreadPool(threadPoolKey, this.properties.coreSize(), this.properties.coreSize(), this.properties.keepAliveTimeMinutes(), TimeUnit.MINUTES, this.queue);
            this.metrics = new HystrixThreadPoolMetrics(threadPoolKey, this.threadPool, this.properties);
            HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(metricsPublisher, threadPoolKey, this.metrics, this.properties);
        }

        @Override
        public ThreadPoolExecutor getExecutor() {
            this.threadPool.setCorePoolSize(this.properties.coreSize().get());
            this.threadPool.setMaximumPoolSize(this.properties.coreSize().get());
            this.threadPool.setKeepAliveTime(this.properties.keepAliveTimeMinutes().get().intValue(), TimeUnit.MINUTES);
            return this.threadPool;
        }

        @Override
        public void markThreadExecution() {
            this.metrics.markThreadExecution();
        }

        @Override
        public void markThreadCompletion() {
            this.metrics.markThreadCompletion();
        }

        @Override
        public boolean isQueueSpaceAvailable() {
            if (this.properties.maxQueueSize().get() < 0) {
                return true;
            }
            return this.threadPool.getQueue().size() < this.properties.queueSizeRejectionThreshold().get();
        }
    }

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixThreadPool> threadPools = new ConcurrentHashMap();

        static HystrixThreadPool getInstance(HystrixThreadPoolKey threadPoolKey, HystrixConcurrencyStrategy concurrencyStrategy, HystrixMetricsPublisher metricsPublisher, HystrixPropertiesStrategy propertiesFactory, HystrixThreadPoolProperties.Setter propertiesBuilder) {
            String key = threadPoolKey.name();
            HystrixThreadPool previouslyCached = threadPools.get(key);
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixThreadPool poolForKey = threadPools.putIfAbsent(key, new HystrixThreadPoolDefault(threadPoolKey, concurrencyStrategy, metricsPublisher, propertiesFactory, propertiesBuilder));
            if (poolForKey == null) {
                HystrixThreadPool threadPoolJustCreated = threadPools.get(key);
                return threadPoolJustCreated;
            }
            return poolForKey;
        }
    }
}

