/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.util.HystrixRollingNumber;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.concurrent.ThreadPoolExecutor;

public class HystrixThreadPoolMetrics {
    private final HystrixRollingNumber counter;
    private final ThreadPoolExecutor threadPool;

    HystrixThreadPoolMetrics(HystrixThreadPoolKey threadPoolKey, ThreadPoolExecutor threadPool, HystrixThreadPoolProperties properties) {
        this.threadPool = threadPool;
        this.counter = new HystrixRollingNumber(properties.metricsRollingStatisticalWindowInMilliseconds(), properties.metricsRollingStatisticalWindowBuckets());
    }

    public Number getCurrentActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public Number getCurrentCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public Number getCurrentCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public Number getCurrentLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public Number getCurrentMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public Number getCurrentPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public Number getCurrentTaskCount() {
        return this.threadPool.getTaskCount();
    }

    public Number getCurrentQueueSize() {
        return this.threadPool.getQueue().size();
    }

    public void markThreadExecution() {
        this.counter.increment(HystrixRollingNumberEvent.THREAD_EXECUTION);
        this.setMaxActiveThreads();
    }

    public long getRollingCountThreadsExecuted() {
        return this.counter.getRollingSum(HystrixRollingNumberEvent.THREAD_EXECUTION);
    }

    public long getCumulativeCountThreadsExecuted() {
        return this.counter.getCumulativeSum(HystrixRollingNumberEvent.THREAD_EXECUTION);
    }

    public void markThreadCompletion() {
        this.setMaxActiveThreads();
    }

    public long getRollingMaxActiveThreads() {
        return this.counter.getRollingMaxValue(HystrixRollingNumberEvent.THREAD_MAX_ACTIVE);
    }

    private void setMaxActiveThreads() {
        this.counter.updateRollingMax(HystrixRollingNumberEvent.THREAD_MAX_ACTIVE, this.threadPool.getActiveCount());
    }
}

