/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherDefault;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;

public class HystrixPlugins {
    private static final HystrixPlugins INSTANCE = new HystrixPlugins();
    private volatile HystrixEventNotifier notifier = null;
    private volatile HystrixConcurrencyStrategy concurrencyStrategy = null;
    private volatile HystrixMetricsPublisher metricsPublisher = null;
    private volatile HystrixPropertiesStrategy propertiesFactory = null;

    private HystrixPlugins() {
    }

    public static HystrixPlugins getInstance() {
        return INSTANCE;
    }

    public HystrixEventNotifier getEventNotifier(HystrixEventNotifier injected) {
        if (this.notifier != null) {
            return this.notifier;
        }
        if (injected != null) {
            return injected;
        }
        return HystrixEventNotifierDefault.getInstance();
    }

    public void registerEventNotifier(HystrixEventNotifier impl) {
        this.notifier = impl;
    }

    public void resetToDefaults() {
        this.notifier = null;
    }

    public HystrixConcurrencyStrategy getConcurrencyStrategy(HystrixConcurrencyStrategy injected) {
        if (this.concurrencyStrategy != null) {
            return this.concurrencyStrategy;
        }
        if (injected != null) {
            return injected;
        }
        return HystrixConcurrencyStrategyDefault.getInstance();
    }

    public void registerConcurrencyStrategy(HystrixConcurrencyStrategy impl) {
        this.concurrencyStrategy = impl;
    }

    public HystrixMetricsPublisher getMetricsPublisher(HystrixMetricsPublisher injected) {
        if (this.metricsPublisher != null) {
            return this.metricsPublisher;
        }
        if (injected != null) {
            return injected;
        }
        return HystrixMetricsPublisherDefault.getInstance();
    }

    public void registerMetricsPublisher(HystrixMetricsPublisher impl) {
        this.metricsPublisher = impl;
    }

    public HystrixPropertiesStrategy getPropertiesStrategy(HystrixPropertiesStrategy injected) {
        if (this.propertiesFactory != null) {
            return this.propertiesFactory;
        }
        if (injected != null) {
            return injected;
        }
        return HystrixPropertiesStrategyDefault.getInstance();
    }

    public void registerPropertiesStrategy(HystrixPropertiesStrategy impl) {
        this.propertiesFactory = impl;
    }
}

