/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.metrics;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class HystrixMetricsPublisherFactory {
    private static final ConcurrentHashMap<String, HystrixMetricsPublisherCommand> commandPublishers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, HystrixMetricsPublisherThreadPool> threadPoolPublishers = new ConcurrentHashMap();

    public static HystrixMetricsPublisherCommand createOrRetrievePublisherForCommand(HystrixMetricsPublisher metricsPublisher, HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        HystrixMetricsPublisherCommand publisher = commandPublishers.get(commandKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = HystrixPlugins.getInstance().getMetricsPublisher(metricsPublisher).getMetricsPublisherForCommand(commandKey, commandOwner, metrics, circuitBreaker, properties);
        HystrixMetricsPublisherCommand existing = commandPublishers.putIfAbsent(commandKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }

    public static HystrixMetricsPublisherThreadPool createOrRetrievePublisherForThreadPool(HystrixMetricsPublisher metricsPublisher, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        HystrixMetricsPublisherThreadPool publisher = threadPoolPublishers.get(threadPoolKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = HystrixPlugins.getInstance().getMetricsPublisher(metricsPublisher).getMetricsPublisherForThreadPool(threadPoolKey, metrics, properties);
        HystrixMetricsPublisherThreadPool existing = threadPoolPublishers.putIfAbsent(threadPoolKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }

    private static enum TestThreadPoolKey implements HystrixThreadPoolKey
    {
        TEST_A,
        TEST_B;

    }

    private static enum TestCommandKey implements HystrixCommandKey
    {
        TEST_A,
        TEST_B;

    }

    private static class TestHystrixMetricsPublisher
    extends HystrixMetricsPublisher {
        AtomicInteger commandCounter = new AtomicInteger();
        AtomicInteger threadCounter = new AtomicInteger();

        private TestHystrixMetricsPublisher() {
        }

        @Override
        public HystrixMetricsPublisherCommand getMetricsPublisherForCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
            return new HystrixMetricsPublisherCommand(){

                @Override
                public void initialize() {
                    TestHystrixMetricsPublisher.this.commandCounter.incrementAndGet();
                }
            };
        }

        @Override
        public HystrixMetricsPublisherThreadPool getMetricsPublisherForThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
            return new HystrixMetricsPublisherThreadPool(){

                @Override
                public void initialize() {
                    TestHystrixMetricsPublisher.this.threadCounter.incrementAndGet();
                }
            };
        }
    }

    public static class UnitTest {
        @Test
        public void testSingleInitializePerKey() {
            final TestHystrixMetricsPublisher publisher = new TestHystrixMetricsPublisher();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < 20; ++i) {
                threads.add(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(publisher, TestCommandKey.TEST_A, null, null, null, null);
                        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(publisher, TestCommandKey.TEST_B, null, null, null, null);
                        HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(publisher, TestThreadPoolKey.TEST_A, null, null);
                    }
                }));
            }
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)2L, (long)publisher.commandCounter.get());
            Assert.assertEquals((long)1L, (long)publisher.threadCounter.get());
        }
    }
}

