/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.metrics;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsServoPublisherAbstract;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;

public class HystrixMetricsPublisherThreadPoolDefault
extends HystrixMetricsServoPublisherAbstract
implements HystrixMetricsPublisherThreadPool {
    private final HystrixThreadPoolKey key;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;

    public HystrixMetricsPublisherThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.key.name();
            }

            public String tagString() {
                return HystrixMetricsPublisherThreadPoolDefault.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixThreadPool";
            }

            public String tagString() {
                return "HystrixThreadPool";
            }
        };
    }

    @Override
    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixThreadPool_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"name").build()){

            public String getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.key.name();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"currentTime").withTag((Tag)DataSourceLevel.DEBUG).build()){

            public Number getValue() {
                return System.currentTimeMillis();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"threadActiveCount").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCurrentActiveCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"completedTaskCount").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCurrentCompletedTaskCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"largestPoolSize").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCurrentLargestPoolSize();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"totalTaskCount").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCurrentTaskCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"queueSize").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCurrentQueueSize();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"rollingMaxActiveThreads").withTag((Tag)DataSourceLevel.DEBUG).build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getRollingMaxActiveThreads();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.CounterMetric(MonitorConfig.builder((String)"countThreadsExecuted").build()){

            public Long getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getCumulativeCountThreadsExecuted();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"rollingCountThreadsExecuted").withTag((Tag)DataSourceLevel.DEBUG).build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.metrics.getRollingCountThreadsExecuted();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_corePoolSize").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.properties.coreSize().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_keepAliveTimeInMinutes").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.properties.keepAliveTimeMinutes().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_queueSizeRejectionThreshold").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.properties.queueSizeRejectionThreshold().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixMetricsServoPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_maxQueueSize").build()){

            public Number getValue() {
                return HystrixMetricsPublisherThreadPoolDefault.this.properties.maxQueueSize().get();
            }
        });
        return monitors;
    }
}

