/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BasicStopwatch
implements Stopwatch {
    private Timer timer;
    private AtomicLong startTime = new AtomicLong(0L);
    private AtomicLong endTime = new AtomicLong(0L);

    public BasicStopwatch() {
        this(null);
    }

    public BasicStopwatch(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void start() {
        this.startTime.set(System.nanoTime());
    }

    @Override
    public void stop() {
        this.endTime.set(System.nanoTime());
        if (this.timer != null) {
            this.timer.record(this.getDuration(this.timer.getTimeUnit()));
        }
    }

    @Override
    public void reset() {
        this.startTime = new AtomicLong(0L);
        this.endTime = new AtomicLong(0L);
    }

    @Override
    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.endTime.get() - this.startTime.get();
    }
}

