/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AnnotatedNumberMonitor;
import com.netflix.servo.monitor.AnnotatedStringMonitor;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.CompositeMonitorWrapper;
import com.netflix.servo.monitor.ContextualCounter;
import com.netflix.servo.monitor.ContextualTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.MonitorWrapper;
import com.netflix.servo.monitor.MonitoredCache;
import com.netflix.servo.monitor.MonitoredThreadPool;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.NumericMonitorWrapper;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.TaggingContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Monitors {
    private static final String DEFAULT_ID = "default";
    private static final CounterFactory COUNTER_FUNCTION = new CounterFactory();

    private Monitors() {
    }

    public static Timer newTimer(String name) {
        return Monitors.newTimer(name, TimeUnit.MILLISECONDS);
    }

    public static Timer newTimer(String name, TaggingContext context) {
        return Monitors.newTimer(name, TimeUnit.MILLISECONDS, context);
    }

    public static Timer newTimer(String name, TimeUnit unit) {
        return new BasicTimer(MonitorConfig.builder(name).build(), unit);
    }

    public static Timer newTimer(String name, TimeUnit unit, TaggingContext context) {
        MonitorConfig config = MonitorConfig.builder(name).build();
        return new ContextualTimer(config, context, new TimerFactory(unit));
    }

    public static Counter newCounter(String name) {
        return new BasicCounter(MonitorConfig.builder(name).build());
    }

    public static Counter newCounter(String name, TaggingContext context) {
        MonitorConfig config = MonitorConfig.builder(name).build();
        return new ContextualCounter(config, context, COUNTER_FUNCTION);
    }

    public static CompositeMonitor<?> newObjectMonitor(Object obj) {
        return Monitors.newObjectMonitor(null, obj);
    }

    public static CompositeMonitor<?> newObjectMonitor(String id, Object obj) {
        TagList tags = Monitors.getMonitorTags(obj);
        ArrayList monitors = Lists.newArrayList();
        Monitors.addMonitors(monitors, id, tags, obj);
        Class<?> c = obj.getClass();
        String objectId = id == null ? DEFAULT_ID : id;
        return new BasicCompositeMonitor(Monitors.newObjectConfig(c, objectId, tags), monitors);
    }

    public static CompositeMonitor<?> newThreadPoolMonitor(String id, ThreadPoolExecutor pool) {
        return Monitors.newObjectMonitor(id, new MonitoredThreadPool(pool));
    }

    public static CompositeMonitor<?> newCacheMonitor(String id, Cache<?, ?> cache) {
        return Monitors.newObjectMonitor(id, new MonitoredCache(cache));
    }

    public static void registerObject(Object obj) {
        Monitors.registerObject(null, obj);
    }

    public static void registerObject(String id, Object obj) {
        DefaultMonitorRegistry.getInstance().register(Monitors.newObjectMonitor(id, obj));
    }

    static <T> Monitor<T> wrap(TagList tags, Monitor<T> monitor) {
        AbstractMonitor m = null;
        m = monitor instanceof CompositeMonitor ? new CompositeMonitorWrapper(tags, (CompositeMonitor)monitor) : (monitor instanceof NumericMonitor ? new NumericMonitorWrapper(tags, (NumericMonitor)monitor) : new MonitorWrapper<T>(tags, monitor));
        return m;
    }

    static void addMonitors(List<Monitor<?>> monitors, String id, TagList tags, Object obj) {
        for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
            Monitors.addMonitorFields(monitors, id, tags, obj, c);
            Monitors.addAnnotatedFields(monitors, id, tags, obj, c);
        }
    }

    static void addMonitorFields(List<Monitor<?>> monitors, String id, TagList tags, Object obj, Class<?> c) {
        try {
            Field[] fields;
            SortedTagList.Builder builder = SortedTagList.builder();
            builder.withTag("class", obj.getClass().getSimpleName());
            if (tags != null) {
                builder.withTags(tags);
            }
            if (id != null) {
                builder.withTag("id", id);
            }
            SortedTagList classTags = builder.build();
            for (Field field : fields = c.getDeclaredFields()) {
                if (!Monitors.isMonitorType(field.getType())) continue;
                field.setAccessible(true);
                monitors.add(Monitors.wrap(classTags, (Monitor)field.get(obj)));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static void addAnnotatedFields(List<Monitor<?>> monitors, String id, TagList tags, Object obj, Class<?> c) {
        Class<com.netflix.servo.annotations.Monitor> annoClass = com.netflix.servo.annotations.Monitor.class;
        try {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                com.netflix.servo.annotations.Monitor anno = field.getAnnotation(annoClass);
                if (anno == null) continue;
                MonitorConfig config = Monitors.newConfig(obj.getClass(), id, anno, tags);
                if (anno.type() == DataSourceType.INFORMATIONAL) {
                    monitors.add(new AnnotatedStringMonitor(config, obj, field));
                    continue;
                }
                Monitors.checkType(anno, field.getType(), c);
                monitors.add(new AnnotatedNumberMonitor(config, obj, field));
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                com.netflix.servo.annotations.Monitor anno = method.getAnnotation(annoClass);
                if (anno == null) continue;
                MonitorConfig config = Monitors.newConfig(obj.getClass(), id, anno, tags);
                if (anno.type() == DataSourceType.INFORMATIONAL) {
                    monitors.add(new AnnotatedStringMonitor(config, obj, method));
                    continue;
                }
                Monitors.checkType(anno, method.getReturnType(), c);
                monitors.add(new AnnotatedNumberMonitor(config, obj, method));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static TagList getMonitorTags(Object obj) {
        try {
            Method[] methods;
            Field[] fields;
            Class<?> c = obj.getClass();
            for (Field field : fields = c.getDeclaredFields()) {
                MonitorTags anno = field.getAnnotation(MonitorTags.class);
                if (anno == null) continue;
                field.setAccessible(true);
                return (TagList)field.get(obj);
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                MonitorTags anno = method.getAnnotation(MonitorTags.class);
                if (anno == null) continue;
                method.setAccessible(true);
                return (TagList)method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    private static void checkType(com.netflix.servo.annotations.Monitor anno, Class<?> type, Class<?> container) {
        if (!Monitors.isNumericType(type)) {
            String msg = "annotation of type " + anno.type().name() + " can only be used" + " with numeric values, " + anno.name() + " in class " + container.getName() + " is applied to a field or method of type " + type.getName();
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean isNumericType(Class<?> c) {
        return Number.class.isAssignableFrom(c) || Double.TYPE == c || Float.TYPE == c || Long.TYPE == c || Integer.TYPE == c || Short.TYPE == c || Byte.TYPE == c;
    }

    private static boolean isMonitorType(Class<?> c) {
        return Monitor.class.isAssignableFrom(c);
    }

    private static MonitorConfig newObjectConfig(Class<?> c, String id, TagList tags) {
        MonitorConfig.Builder builder = MonitorConfig.builder(id);
        builder.withTag("class", c.getSimpleName());
        if (tags != null) {
            builder.withTags(tags);
        }
        return builder.build();
    }

    private static MonitorConfig newConfig(Class<?> c, String id, com.netflix.servo.annotations.Monitor anno, TagList tags) {
        MonitorConfig.Builder builder = MonitorConfig.builder(anno.name());
        builder.withTag("class", c.getSimpleName());
        builder.withTag(anno.type());
        builder.withTag(anno.level());
        if (tags != null) {
            builder.withTags(tags);
        }
        if (id != null) {
            builder.withTag("id", id);
        }
        return builder.build();
    }

    private static class CounterFactory
    implements Function<MonitorConfig, Counter> {
        private CounterFactory() {
        }

        public Counter apply(MonitorConfig config) {
            return new BasicCounter(config);
        }
    }

    private static class TimerFactory
    implements Function<MonitorConfig, Timer> {
        private final TimeUnit unit;

        public TimerFactory(TimeUnit unit) {
            this.unit = unit;
        }

        public Timer apply(MonitorConfig config) {
            return new BasicTimer(config, this.unit);
        }
    }
}

