/*
 * Decompiled with CFR 0.152.
 */
package com.tinify;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.tinify.ConnectionException;
import com.tinify.Exception;
import com.tinify.Options;
import com.tinify.SSLContext;
import com.tinify.Tinify;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class Client {
    private OkHttpClient client = new OkHttpClient();
    private String credentials;
    private String userAgent;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String API_ENDPOINT = "https://api.tinify.com";
    public static final short RETRY_COUNT = 1;
    public static final short RETRY_DELAY = 500;
    public static final String USER_AGENT = "Tinify/" + Client.class.getPackage().getImplementationVersion() + " Java/" + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ", " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + ")";

    public Client(String key) {
        this(key, null, null);
    }

    public Client(String key, String appIdentifier) {
        this(key, appIdentifier, null);
    }

    public Client(String key, String appIdentifier, String proxy) {
        if (proxy != null) {
            try {
                URL url = new URL(proxy);
                Proxy proxyAddress = this.createProxyAddress(url);
                Authenticator proxyAuthenticator = this.createProxyAuthenticator(url);
                if (proxyAddress != null) {
                    this.client.setProxy(proxyAddress);
                    if (proxyAuthenticator != null) {
                        this.client.setAuthenticator(proxyAuthenticator);
                    }
                }
            }
            catch (java.lang.Exception e) {
                throw new ConnectionException("Invalid proxy: " + e.getMessage(), e);
            }
        }
        this.client.setSslSocketFactory(SSLContext.getSocketFactory());
        this.client.setConnectTimeout(0L, TimeUnit.SECONDS);
        this.client.setReadTimeout(0L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(0L, TimeUnit.SECONDS);
        this.credentials = Credentials.basic((String)"api", (String)key);
        this.userAgent = appIdentifier == null ? USER_AGENT : USER_AGENT + " " + appIdentifier;
    }

    public final Response request(Method method, String endpoint) throws Exception {
        if (method.equals((Object)Method.POST)) {
            return this.request(method, endpoint, RequestBody.create(null, (byte[])new byte[0]));
        }
        return this.request(method, endpoint, (RequestBody)null);
    }

    public final Response request(Method method, String endpoint, Options options) throws Exception {
        if (method.equals((Object)Method.GET)) {
            return this.request(method, endpoint, options.isEmpty() ? null : RequestBody.create((MediaType)JSON, (String)options.toJson()));
        }
        return this.request(method, endpoint, RequestBody.create((MediaType)JSON, (String)options.toJson()));
    }

    public final Response request(Method method, String endpoint, byte[] body) throws Exception {
        return this.request(method, endpoint, RequestBody.create(null, (byte[])body));
    }

    private Proxy createProxyAddress(URL proxy) {
        if (proxy == null) {
            return null;
        }
        String host = proxy.getHost();
        int port = proxy.getPort();
        if (port < 0) {
            port = proxy.getDefaultPort();
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    private Authenticator createProxyAuthenticator(URL proxy) {
        String password;
        String username;
        if (proxy == null) {
            return null;
        }
        String user = proxy.getUserInfo();
        if (user == null) {
            return null;
        }
        int c = user.indexOf(58);
        if (0 < c) {
            username = user.substring(0, c);
            password = user.substring(c + 1);
        } else {
            username = user;
            password = null;
        }
        return new Authenticator(){

            public Request authenticate(Proxy proxy, Response response) throws IOException {
                return null;
            }

            public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
                String credential = Credentials.basic((String)username, (String)password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
        };
    }

    private Response request(Method method, String endpoint, RequestBody body) throws Exception {
        HttpUrl url = endpoint.startsWith("https") ? HttpUrl.parse((String)endpoint) : HttpUrl.parse((String)(API_ENDPOINT + endpoint));
        for (int retries = 1; retries >= 0; retries = (int)((short)(retries - 1))) {
            Exception.Data data;
            Response response;
            if (retries < 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            Request request = new Request.Builder().header("Authorization", this.credentials).header("User-Agent", this.userAgent).url(url).method(method.toString(), body).build();
            try {
                response = this.client.newCall(request).execute();
            }
            catch (java.lang.Exception e) {
                if (retries > 0) continue;
                throw new ConnectionException("Error while connecting: " + e.getMessage(), e);
            }
            String compressionCount = response.header("Compression-Count");
            if (compressionCount != null && !compressionCount.isEmpty()) {
                Tinify.setCompressionCount(Integer.valueOf(compressionCount));
            }
            if (response.isSuccessful()) {
                return response;
            }
            Gson gson = new Gson();
            try {
                data = (Exception.Data)gson.fromJson(response.body().charStream(), Exception.Data.class);
                if (data == null) {
                    data = new Exception.Data();
                    data.setMessage("Error while parsing response: received empty body");
                    data.setError("ParseError");
                }
            }
            catch (JsonParseException e) {
                data = new Exception.Data();
                data.setMessage("Error while parsing response: " + e.getMessage());
                data.setError("ParseError");
            }
            catch (IOException e) {
                if (retries > 0) continue;
                throw new ConnectionException("Error while reading data: " + e.getMessage(), e);
            }
            if (retries > 0 && response.code() >= 500) continue;
            throw Exception.create(data.getMessage(), data.getError(), response.code());
        }
        return null;
    }

    public static enum Method {
        POST,
        GET;

    }
}

