/*
 * Decompiled with CFR 0.152.
 */
package com.tinify;

import com.squareup.okhttp.Response;
import com.tinify.Client;
import com.tinify.Options;
import com.tinify.Result;
import com.tinify.ResultMeta;
import com.tinify.Tinify;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Source {
    private String url;
    private Options commands;

    public static Source fromFile(String path) throws IOException {
        return Source.fromBuffer(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    public static Source fromBuffer(byte[] buffer) {
        Response response = Tinify.client().request(Client.Method.POST, "/shrink", buffer);
        return new Source(response.header("location"), new Options());
    }

    public static Source fromUrl(String url) {
        Options body = new Options().with("source", new Options().with("url", url));
        Response response = Tinify.client().request(Client.Method.POST, "/shrink", body);
        return new Source(response.header("location"), new Options());
    }

    public Source(String url, Options commands) {
        this.url = url;
        this.commands = commands;
    }

    public final Source preserve(String ... options) {
        return new Source(this.url, new Options(this.commands).with("preserve", options));
    }

    public final Source resize(Options options) {
        return new Source(this.url, new Options(this.commands).with("resize", options));
    }

    public final ResultMeta store(Options options) {
        Response response = Tinify.client().request(Client.Method.POST, this.url, new Options(this.commands).with("store", options));
        return new ResultMeta(response.headers());
    }

    public final Result result() throws IOException {
        Response response = this.commands == null ? Tinify.client().request(Client.Method.GET, this.url) : Tinify.client().request(Client.Method.POST, this.url, this.commands);
        return new Result(response.headers(), response.body().bytes());
    }

    public void toFile(String path) throws IOException {
        this.result().toFile(path);
    }

    public final byte[] toBuffer() throws IOException {
        return this.result().toBuffer();
    }
}

