/*
 * Decompiled with CFR 0.152.
 */
package com.tinify;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.tinify.ConnectionException;
import com.tinify.Exception;
import com.tinify.Options;
import com.tinify.TLSContext;
import com.tinify.Tinify;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Route;

public class Client {
    private OkHttpClient client;
    private String credentials;
    private String userAgent;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String API_ENDPOINT = "https://api.tinify.com";
    public static final short RETRY_COUNT = 1;
    public static final short RETRY_DELAY = 500;
    public static final String USER_AGENT = "Tinify/" + Client.class.getPackage().getImplementationVersion() + " Java/" + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ", " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + ")";

    public Client(String key) {
        this(key, null, null);
    }

    public Client(String key, String appIdentifier) {
        this(key, appIdentifier, null);
    }

    public Client(String key, String appIdentifier, String proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (proxy != null) {
            try {
                URL url = new URL(proxy);
                Proxy proxyAddress = this.createProxyAddress(url);
                Authenticator proxyAuthenticator = this.createProxyAuthenticator(url);
                if (proxyAddress != null) {
                    builder.proxy(proxyAddress);
                    if (proxyAuthenticator != null) {
                        builder.proxyAuthenticator(proxyAuthenticator);
                    }
                }
            }
            catch (java.lang.Exception e) {
                throw new ConnectionException("Invalid proxy: " + e.getMessage(), e);
            }
        }
        builder.sslSocketFactory(TLSContext.socketFactory, TLSContext.trustManager);
        builder.connectTimeout(0L, TimeUnit.SECONDS);
        builder.readTimeout(0L, TimeUnit.SECONDS);
        builder.writeTimeout(0L, TimeUnit.SECONDS);
        this.client = builder.build();
        this.credentials = Credentials.basic((String)"api", (String)key);
        this.userAgent = appIdentifier == null ? USER_AGENT : USER_AGENT + " " + appIdentifier;
    }

    public final Response request(Method method, String endpoint) throws Exception {
        if (method.equals((Object)Method.POST)) {
            return this.request(method, endpoint, RequestBody.create(null, (byte[])new byte[0]));
        }
        return this.request(method, endpoint, (RequestBody)null);
    }

    public final Response request(Method method, String endpoint, Options options) throws Exception {
        if (method.equals((Object)Method.GET)) {
            return this.request(method, endpoint, options.isEmpty() ? null : RequestBody.create((MediaType)JSON, (String)options.toJson()));
        }
        return this.request(method, endpoint, RequestBody.create((MediaType)JSON, (String)options.toJson()));
    }

    public final Response request(Method method, String endpoint, byte[] body) throws Exception {
        return this.request(method, endpoint, RequestBody.create(null, (byte[])body));
    }

    private Proxy createProxyAddress(URL proxy) {
        if (proxy == null) {
            return null;
        }
        String host = proxy.getHost();
        int port = proxy.getPort();
        if (port < 0) {
            port = proxy.getDefaultPort();
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    private Authenticator createProxyAuthenticator(URL proxy) {
        String password;
        String username;
        if (proxy == null) {
            return null;
        }
        String user = proxy.getUserInfo();
        if (user == null) {
            return null;
        }
        int c = user.indexOf(58);
        if (0 < c) {
            username = user.substring(0, c);
            password = user.substring(c + 1);
        } else {
            username = user;
            password = null;
        }
        return new Authenticator(){

            public Request authenticate(Route route, okhttp3.Response response) throws IOException {
                String credential = Credentials.basic((String)username, (String)password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
        };
    }

    private Response request(Method method, String endpoint, RequestBody body) throws Exception {
        HttpUrl url = endpoint.startsWith("https") ? HttpUrl.parse((String)endpoint) : HttpUrl.parse((String)(API_ENDPOINT + endpoint));
        for (int retries = 1; retries >= 0; retries = (int)((short)(retries - 1))) {
            Exception.Data data;
            Response response;
            int status;
            if (retries < 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            Request request = new Request.Builder().header("Authorization", this.credentials).header("User-Agent", this.userAgent).url(url).method(method.toString(), body).build();
            try {
                okhttp3.Response res = this.client.newCall(request).execute();
                status = res.code();
                response = new Response(res.headers(), res.body().bytes());
            }
            catch (java.lang.Exception e) {
                if (retries > 0) continue;
                throw new ConnectionException("Error while connecting: " + e.getMessage(), e);
            }
            String compressionCount = response.headers.get("Compression-Count");
            if (compressionCount != null && !compressionCount.isEmpty()) {
                Tinify.setCompressionCount(Integer.valueOf(compressionCount));
            }
            if (status >= 200 && status < 300) {
                return response;
            }
            Gson gson = new Gson();
            try {
                data = (Exception.Data)gson.fromJson(new String(response.body), Exception.Data.class);
                if (data == null) {
                    data = new Exception.Data();
                    data.setMessage("Error while parsing response: received empty body");
                    data.setError("ParseError");
                }
            }
            catch (JsonParseException e) {
                data = new Exception.Data();
                data.setMessage("Error while parsing response: " + e.getMessage());
                data.setError("ParseError");
            }
            if (retries > 0 && status >= 500) continue;
            throw Exception.create(data.getMessage(), data.getError(), status);
        }
        return null;
    }

    public static enum Method {
        POST,
        GET;

    }

    public class Response {
        public Headers headers;
        public byte[] body;

        public Response(Headers headers, byte[] body) {
            this.headers = headers;
            this.body = body;
        }
    }
}

