/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;

public class ContextScheduler
extends Scheduler {
    private static final Handler<AsyncResult<Object>> NOOP = result -> {};
    private final Vertx vertx;
    private final boolean blocking;
    private final boolean ordered;
    private final RxJavaSchedulersHook schedulersHook = RxJavaPlugins.getInstance().getSchedulersHook();
    private final Context context;
    private static final Object DUMB = new JsonObject();

    public ContextScheduler(Context context, boolean blocking) {
        this(context, blocking, true);
    }

    public ContextScheduler(Context context, boolean blocking, boolean ordered) {
        this.vertx = context.owner();
        this.context = context;
        this.blocking = blocking;
        this.ordered = ordered;
    }

    public ContextScheduler(Vertx vertx, boolean blocking) {
        this(vertx, blocking, true);
    }

    public ContextScheduler(Vertx vertx, boolean blocking, boolean ordered) {
        this.vertx = vertx;
        this.context = null;
        this.blocking = blocking;
        this.ordered = ordered;
    }

    public Scheduler.Worker createWorker() {
        return new WorkerImpl();
    }

    private class WorkerImpl
    extends Scheduler.Worker {
        private final ConcurrentHashMap<TimedAction, Object> actions = new ConcurrentHashMap();
        private final AtomicBoolean cancelled = new AtomicBoolean();

        private WorkerImpl() {
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            action = ContextScheduler.this.schedulersHook.onSchedule(action);
            TimedAction timed = new TimedAction(action, unit.toMillis(delayTime), 0L);
            this.actions.put(timed, DUMB);
            return timed;
        }

        public Subscription schedulePeriodically(Action0 action, long initialDelay, long period, TimeUnit unit) {
            action = ContextScheduler.this.schedulersHook.onSchedule(action);
            TimedAction timed = new TimedAction(action, unit.toMillis(initialDelay), unit.toMillis(period));
            this.actions.put(timed, DUMB);
            return timed;
        }

        public void unsubscribe() {
            if (this.cancelled.compareAndSet(false, true)) {
                ((ConcurrentHashMap.KeySetView)this.actions.keySet()).forEach(TimedAction::unsubscribe);
            }
        }

        public boolean isUnsubscribed() {
            return this.cancelled.get();
        }

        class TimedAction
        implements Subscription,
        Runnable {
            private final Context context;
            private long id;
            private final Action0 action;
            private final long periodMillis;
            private boolean cancelled;

            public TimedAction(Action0 action, long delayMillis, long periodMillis) {
                this.context = ContextScheduler.this.context != null ? ContextScheduler.this.context : ContextScheduler.this.vertx.getOrCreateContext();
                this.cancelled = false;
                this.action = action;
                this.periodMillis = periodMillis;
                if (delayMillis > 0L) {
                    this.schedule(delayMillis);
                } else {
                    this.id = -1L;
                    this.execute(null);
                }
            }

            private void schedule(long delay) {
                this.id = ContextScheduler.this.vertx.setTimer(delay, this::execute);
            }

            private void execute(Object o) {
                if (ContextScheduler.this.blocking) {
                    this.context.executeBlocking(this::run, ContextScheduler.this.ordered, NOOP);
                } else {
                    this.context.runOnContext(this::run);
                }
            }

            private void run(Object arg) {
                this.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimedAction timedAction = this;
                synchronized (timedAction) {
                    if (this.cancelled) {
                        return;
                    }
                }
                this.action.call();
                timedAction = this;
                synchronized (timedAction) {
                    if (this.periodMillis > 0L) {
                        this.schedule(this.periodMillis);
                    }
                }
            }

            public synchronized void unsubscribe() {
                if (!this.cancelled) {
                    WorkerImpl.this.actions.remove(this);
                    if (this.id > 0L) {
                        ContextScheduler.this.vertx.cancelTimer(this.id);
                    }
                    this.cancelled = true;
                }
            }

            public synchronized boolean isUnsubscribed() {
                return this.cancelled;
            }
        }
    }
}

