/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import net.sf.clirr.core.Message;
import net.sf.clirr.core.ScopeSelector;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;

public final class ClassScopeCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_SCOPE_INCREASED = new Message(1000);
    private static final Message MSG_SCOPE_DECREASED = new Message(1001);
    private static final Message MSG_ERROR_DETERMINING_SCOPE_OLD = new Message(1002);
    private static final Message MSG_ERROR_DETERMINING_SCOPE_NEW = new Message(1003);
    private ScopeSelector scopeSelector;

    public ClassScopeCheck(ApiDiffDispatcher dispatcher, ScopeSelector scopeSelector) {
        super(dispatcher);
        this.scopeSelector = scopeSelector;
    }

    public boolean check(JavaType compatBaseline, JavaType currentVersion) {
        Scope bScope = compatBaseline.getEffectiveScope();
        Scope cScope = currentVersion.getEffectiveScope();
        if (!this.scopeSelector.isSelected(bScope) && !this.scopeSelector.isSelected(cScope)) {
            return false;
        }
        if (cScope.isMoreVisibleThan(bScope)) {
            String[] args = new String[]{bScope.getDesc(), cScope.getDesc()};
            this.log(MSG_SCOPE_INCREASED, Severity.INFO, compatBaseline.getName(), null, null, args);
        } else if (cScope.isLessVisibleThan(bScope)) {
            String[] args = new String[]{bScope.getDesc(), cScope.getDesc()};
            this.log(MSG_SCOPE_DECREASED, this.getSeverity(compatBaseline, Severity.ERROR), compatBaseline.getName(), null, null, args);
        }
        return this.scopeSelector.isSelected(bScope) && this.scopeSelector.isSelected(cScope);
    }
}

