/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Sink;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.sink.LoadBalancingSinkProcessor;

public abstract class AbstractSinkSelector
implements LoadBalancingSinkProcessor.SinkSelector {
    private LifecycleState state;
    private List<Sink> sinkList;
    protected long maxTimeOut = 0L;

    @Override
    public void configure(Context context) {
        Long timeOut = context.getLong("maxTimeOut");
        if (timeOut != null) {
            this.maxTimeOut = timeOut;
        }
    }

    @Override
    public void start() {
        this.state = LifecycleState.START;
    }

    @Override
    public void stop() {
        this.state = LifecycleState.STOP;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.state;
    }

    @Override
    public void setSinks(List<Sink> sinks) {
        this.sinkList = new ArrayList<Sink>();
        this.sinkList.addAll(sinks);
    }

    protected List<Sink> getSinks() {
        return this.sinkList;
    }

    @Override
    public void informSinkFailed(Sink failedSink) {
    }
}

