/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avro.ipc.Server;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.FailoverRpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.api.RpcTestUtils;
import org.apache.flume.event.EventBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestFailoverRpcClient {
    @Test
    public void testFailover() throws FlumeException, EventDeliveryException, InterruptedException {
        int i;
        FailoverRpcClient client = null;
        Server server1 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Server server2 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Server server3 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Properties props = new Properties();
        int s1Port = server1.getPort();
        int s2Port = server2.getPort();
        int s3Port = server3.getPort();
        props.put("client.type", "default_failover");
        props.put("hosts", "host1 host2 host3");
        props.put("hosts.host1", "127.0.0.1:" + String.valueOf(s1Port));
        props.put("hosts.host2", "127.0.0.1:" + String.valueOf(s2Port));
        props.put("hosts.host3", "127.0.0.1:" + String.valueOf(s3Port));
        client = (FailoverRpcClient)RpcClientFactory.getInstance((Properties)props);
        ArrayList<Event> events = new ArrayList<Event>();
        for (i = 0; i < 50; ++i) {
            events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        Assert.assertEquals((Object)client.getLastConnectedServerAddress(), (Object)new InetSocketAddress("127.0.0.1", server1.getPort()));
        server1.close();
        Thread.sleep(1000L);
        events = new ArrayList();
        for (i = 0; i < 50; ++i) {
            events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        Assert.assertEquals((Object)new InetSocketAddress("localhost", server2.getPort()), (Object)client.getLastConnectedServerAddress());
        server2.close();
        Thread.sleep(1000L);
        client.append(EventBuilder.withBody((String)"Had a sandwich?", (Charset)Charset.forName("UTF8")));
        Assert.assertEquals((Object)new InetSocketAddress("localhost", server3.getPort()), (Object)client.getLastConnectedServerAddress());
        Server server4 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler(), s2Port);
        server3.close();
        Thread.sleep(1000L);
        events = new ArrayList();
        for (int i2 = 0; i2 < 50; ++i2) {
            events.add(EventBuilder.withBody((String)("evt: " + i2), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        Assert.assertEquals((Object)new InetSocketAddress("localhost", s2Port), (Object)client.getLastConnectedServerAddress());
        Server server5 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler(), s1Port);
        client.append(EventBuilder.withBody((String)"Had a mango?", (Charset)Charset.forName("UTF8")));
        Assert.assertEquals((Object)new InetSocketAddress("localhost", s2Port), (Object)client.getLastConnectedServerAddress());
        server4.close();
        Thread.sleep(1000L);
        events = new ArrayList();
        for (int i3 = 0; i3 < 50; ++i3) {
            events.add(EventBuilder.withBody((String)("evt: " + i3), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        Assert.assertEquals((Object)new InetSocketAddress("localhost", s1Port), (Object)client.getLastConnectedServerAddress());
        server5.close();
        Thread.sleep(1000L);
        Server server6 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler(), s1Port);
        client.append(EventBuilder.withBody((String)"Had a whole watermelon?", (Charset)Charset.forName("UTF8")));
        Assert.assertEquals((Object)new InetSocketAddress("localhost", s1Port), (Object)client.getLastConnectedServerAddress());
        server6.close();
        Thread.sleep(1000L);
        Server server7 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler(), s3Port);
        events = new ArrayList();
        for (int i4 = 0; i4 < 50; ++i4) {
            events.add(EventBuilder.withBody((String)("evt: " + i4), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        Assert.assertEquals((Object)new InetSocketAddress("localhost", s3Port), (Object)client.getLastConnectedServerAddress());
        server7.close();
    }

    @Test(expected=EventDeliveryException.class)
    public void testFailedServers() throws FlumeException, EventDeliveryException {
        int i;
        FailoverRpcClient client = null;
        Server server1 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Server server2 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Server server3 = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        Properties props = new Properties();
        props.put("client.type", "default_failover");
        props.put("hosts", "host1 host2 host3");
        props.put("hosts.host1", "localhost:" + String.valueOf(server1.getPort()));
        props.put("hosts.host2", "localhost:" + String.valueOf(server2.getPort()));
        props.put("hosts.host3", " localhost:" + String.valueOf(server3.getPort()));
        client = (FailoverRpcClient)RpcClientFactory.getInstance((Properties)props);
        ArrayList<Event> events = new ArrayList<Event>();
        for (i = 0; i < 50; ++i) {
            events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
        server1.close();
        server2.close();
        server3.close();
        events = new ArrayList();
        for (i = 0; i < 50; ++i) {
            events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
        }
        client.appendBatch(events);
    }
}

