/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avro.ipc.Server;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.api.RpcTestUtils;
import org.apache.flume.event.EventBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcClientFactory {
    private static final String localhost = "localhost";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoParamSimpleAppend() throws FlumeException, EventDeliveryException {
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            client = RpcClientFactory.getDefaultInstance((String)localhost, (Integer)server.getPort());
            client.append(EventBuilder.withBody((String)"wheee!!!", (Charset)Charset.forName("UTF8")));
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoParamDeprecatedAppend() throws FlumeException, EventDeliveryException {
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            client = RpcClientFactory.getInstance((String)localhost, (Integer)server.getPort());
            client.append(EventBuilder.withBody((String)"wheee!!!", (Charset)Charset.forName("UTF8")));
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreeParamDeprecatedAppend() throws FlumeException, EventDeliveryException {
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            client = RpcClientFactory.getInstance((String)localhost, (Integer)server.getPort(), (Integer)3);
            Assert.assertEquals((String)"Batch size was specified", (long)3L, (long)client.getBatchSize());
            client.append(EventBuilder.withBody((String)"wheee!!!", (Charset)Charset.forName("UTF8")));
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreeParamBatchAppend() throws FlumeException, EventDeliveryException {
        int batchSize = 7;
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            client = RpcClientFactory.getDefaultInstance((String)localhost, (Integer)server.getPort(), (Integer)batchSize);
            ArrayList<Event> events = new ArrayList<Event>();
            for (int i = 0; i < batchSize; ++i) {
                events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
            }
            client.appendBatch(events);
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesBatchAppend() throws FlumeException, EventDeliveryException {
        int batchSize = 7;
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            Properties p = new Properties();
            p.put("hosts", "host1");
            p.put("hosts.host1", "localhost:" + String.valueOf(server.getPort()));
            p.put("batch-size", String.valueOf(batchSize));
            client = RpcClientFactory.getInstance((Properties)p);
            ArrayList<Event> events = new ArrayList<Event>();
            for (int i = 0; i < batchSize; ++i) {
                events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
            }
            client.appendBatch(events);
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoParamBatchAppendOverflow() throws FlumeException, EventDeliveryException {
        RpcClient client = null;
        Server server = RpcTestUtils.startServer(new RpcTestUtils.OKAvroHandler());
        try {
            client = RpcClientFactory.getDefaultInstance((String)localhost, (Integer)server.getPort());
            int batchSize = client.getBatchSize();
            int moreThanBatch = batchSize + 1;
            ArrayList<Event> events = new ArrayList<Event>();
            for (int i = 0; i < moreThanBatch; ++i) {
                events.add(EventBuilder.withBody((String)("evt: " + i), (Charset)Charset.forName("UTF8")));
            }
            client.appendBatch(events);
        }
        finally {
            RpcTestUtils.stopServer(server);
            if (client != null) {
                client.close();
            }
        }
    }
}

