/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.CountDownLatch;

class InstancePending<T> {
    private final CountDownLatch pendingLatch = new CountDownLatch(1);
    private InstanceHolder<T> instanceHolder;

    InstancePending() {
    }

    T get() {
        InstanceHolder<T> instanceHolder;
        boolean interrupted = false;
        while ((instanceHolder = this.instanceHolder) == null) {
            try {
                this.pendingLatch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return instanceHolder.instance;
    }

    void prepare(T instance) {
        assert (instance != null);
        this.instanceHolder = new InstanceHolder<T>(instance);
        this.pendingLatch.countDown();
    }

    private static class InstanceHolder<T> {
        final T instance;

        InstanceHolder(T instance) {
            this.instance = instance;
        }
    }
}

