/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.ConfigType$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y\tcBA\u0005 \u0013\t\u0001#\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\u000b\u0011!)\u0003A!A!\u0002\u0013i\u0012A\u0002;pa&\u001c\u0007\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"AQ\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003\u0011!\u0018.\\3\u0011\u0005=\t\u0014B\u0001\u001a\u0011\u0005\u0011!\u0016.\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\naB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u00027s5\tqG\u0003\u00029\t\u000511/\u001a:wKJL!AO\u001c\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"RA\u0010!B\u0005\u000e\u0003\"a\u0010\u0001\u000e\u0003\tAQaG\u001eA\u0002uAQaJ\u001eA\u0002%BQaL\u001eA\u0002ABQ\u0001N\u001eA\u0002UBq!\u0012\u0001C\u0002\u0013%\u0001&A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\u0015\u0002\u001d1|7-\u00197Ce>\\WM]%eA!9\u0011\n\u0001b\u0001\n\u0013Q\u0015A\u00037pO6\u000bg.Y4feV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\t\u0005\u0019An\\4\n\u0005Ak%A\u0003'pO6\u000bg.Y4fe\"1!\u000b\u0001Q\u0001\n-\u000b1\u0002\\8h\u001b\u0006t\u0017mZ3sA!9A\u000b\u0001b\u0001\n\u0013)\u0016a\u0002>l+RLGn]\u000b\u0002-B\u0011qbV\u0005\u00031B\u0011qAW6Vi&d7\u000f\u0003\u0004[\u0001\u0001\u0006IAV\u0001\tu.,F/\u001b7tA!9A\f\u0001b\u0001\n\u0013i\u0016AE1tg&<g.\u001a3SKBd\u0017nY1NCB,\u0012A\u0018\t\u0005\u001f}K\u0013-\u0003\u0002a!\t!\u0001k\\8m!\ty$-\u0003\u0002d\u0005\t9!+\u001a9mS\u000e\f\u0007BB3\u0001A\u0003%a,A\nbgNLwM\\3e%\u0016\u0004H.[2b\u001b\u0006\u0004\b\u0005C\u0004h\u0001\t\u0007I\u0011\u00025\u0002'1,\u0017\rZ3s\u0013N\u0014X\u000b\u001d3bi\u0016dunY6\u0016\u0003%\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\u000b1|7m[:\u000b\u00059|\u0017AC2p]\u000e,(O]3oi*\u0011\u0001/]\u0001\u0005kRLGNC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q\\'A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\rY\u0004\u0001\u0015!\u0003j\u0003QaW-\u00193fe&\u001b(/\u00169eCR,Gj\\2lA!9\u0001\u0010\u0001a\u0001\n\u0013A\u0013!\u0003>l-\u0016\u00148/[8o\u0011\u001dQ\b\u00011A\u0005\nm\fQB_6WKJ\u001c\u0018n\u001c8`I\u0015\fHC\u0001?\u0000!\tIQ0\u0003\u0002\u007f\u0015\t!QK\\5u\u0011!\t\t!_A\u0001\u0002\u0004I\u0013a\u0001=%c!9\u0011Q\u0001\u0001!B\u0013I\u0013A\u0003>l-\u0016\u00148/[8oA!A\u0011\u0011\u0002\u0001A\u0002\u0013%\u0001&A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fHc\u0001?\u0002\u0012!I\u0011\u0011AA\u0006\u0003\u0003\u0005\r!\u000b\u0005\b\u0003+\u0001\u0001\u0015)\u0003*\u00031aW-\u00193fe\u0016\u0003xn\u00195!Q\u0011\t\u0019\"!\u0007\u0011\u0007%\tY\"C\u0002\u0002\u001e)\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003C\u0001\u0001\u0019!C\u0001\u0003G\t!\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qiV\u0011\u0011Q\u0005\t\u0005\u0013\u0005\u001d\u0012&C\u0002\u0002*)\u0011aa\u00149uS>t\u0007\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u0003YaW-\u00193feJ+\u0007\u000f\\5dC&#w\n\u001d;`I\u0015\fHc\u0001?\u00022!Q\u0011\u0011AA\u0016\u0003\u0003\u0005\r!!\n\t\u0011\u0005U\u0002\u0001)Q\u0005\u0003K\t1\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qi\u0002BC!a\r\u0002\u001a!I\u00111\b\u0001A\u0002\u0013\u0005\u0011QH\u0001\u000fS:\u001c\u0016P\\2SKBd\u0017nY1t+\t\ty\u0004E\u0003\u0002B\u0005-\u0013-\u0004\u0002\u0002D)!\u0011QIA$\u0003%IW.\\;uC\ndWMC\u0002\u0002J)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0011\u0003\u0007M+G\u000fC\u0005\u0002R\u0001\u0001\r\u0011\"\u0001\u0002T\u0005\u0011\u0012N\\*z]\u000e\u0014V\r\u001d7jG\u0006\u001cx\fJ3r)\ra\u0018Q\u000b\u0005\u000b\u0003\u0003\ty%!AA\u0002\u0005}\u0002\u0002CA-\u0001\u0001\u0006K!a\u0010\u0002\u001f%t7+\u001f8d%\u0016\u0004H.[2bg\u0002BC!a\u0016\u0002\u001a!A\u0011q\f\u0001A\u0002\u0013%\u0001&A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011%\t\u0019\u0007\u0001a\u0001\n\u0013\t)'A\nd_:$(o\u001c7mKJ,\u0005o\\2i?\u0012*\u0017\u000fF\u0002}\u0003OB\u0011\"!\u0001\u0002b\u0005\u0005\t\u0019A\u0015\t\u000f\u0005-\u0004\u0001)Q\u0005S\u0005\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u0003_\u0002A\u0011BA9\u00039I7OU3qY&\u001c\u0017\rT8dC2$B!a\u001d\u0002zA\u0019\u0011\"!\u001e\n\u0007\u0005]$BA\u0004C_>dW-\u00198\t\u000f\u0005m\u0014Q\u000ea\u0001S\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\n\u0003\u007f\u0002!\u0019!C\u0001\u0003\u0003\u000bA\u0001^1hgV\u0011\u00111\u0011\t\t\u0003\u0003\n))!#\u0002\n&!\u0011qQA\"\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011qR9\u0002\t1\fgnZ\u0005\u0004E\u00055\u0005\u0002CAK\u0001\u0001\u0006I!a!\u0002\u000bQ\fwm\u001d\u0011\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u0006\t\u0012n]+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3\u0015\u0005\u0005M\u0004bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\u0013O\u0016$xJ]\"sK\u0006$XMU3qY&\u001c\u0017\rF\u0002b\u0003GC\u0011\"a\u001f\u0002\u001eB\u0005\t\u0019A\u0015\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006Qq-\u001a;SKBd\u0017nY1\u0015\t\u0005-\u0016Q\u0016\t\u0005\u0013\u0005\u001d\u0012\rC\u0005\u0002|\u0005\u0015\u0006\u0013!a\u0001S!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016\u0001\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00134M_\u000e\fG\u000e\u0006\u0002\u0002,\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016!F1eIJ+\u0007\u000f\\5dC&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0004C\u0006m\u0006bBA_\u0003k\u0003\r!Y\u0001\be\u0016\u0004H.[2b\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007\f\u0001#Y:tS\u001etW\r\u001a*fa2L7-Y:\u0015\u0005\u0005}\u0002bBAd\u0001\u0011\u0005\u0011\u0011Z\u0001\u000ee\u0016lwN^3SKBd\u0017nY1\u0015\u0007q\fY\rC\u0004\u0002|\u0005\u0015\u0007\u0019A\u0015\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\u00061A-\u001a7fi\u0016$\u0012\u0001 \u0005\b\u0003+\u0004A\u0011AAl\u000399W\r\u001e'fC\u0012,'/\u00129pG\"$\u0012!\u000b\u0005\b\u00037\u0004A\u0011AAo\u0003)i\u0017m[3MK\u0006$WM\u001d\u000b\t\u0003g\ny.a9\u0002t\"9\u0011\u0011]Am\u0001\u0004I\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0002CAs\u00033\u0004\r!a:\u0002%A\f'\u000f^5uS>t7\u000b^1uK&sgm\u001c\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002r\u0006-(A\u0005)beRLG/[8o'R\fG/Z%oM>Dq!!>\u0002Z\u0002\u0007\u0011&A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\b\u0003s\u0004A\u0011AA~\u00031i\u0017m[3G_2dwn^3s)!\t\u0019(!@\u0002\u0000\n\u0005\u0001bBAq\u0003o\u0004\r!\u000b\u0005\t\u0003K\f9\u00101\u0001\u0002h\"9\u0011Q_A|\u0001\u0004I\u0003b\u0002B\u0003\u0001\u0011\u0005!qA\u0001\u001bkB$\u0017\r^3SKBd\u0017nY1M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0006y\n%!1\u0002\u0005\b\u0003w\u0012\u0019\u00011\u0001*\u0011!\u0011iAa\u0001A\u0002\t=\u0011!\u00047pOJ+\u0017\r\u001a*fgVdG\u000fE\u00027\u0005#I1Aa\u00058\u00055aun\u001a*fC\u0012\u0014Vm];mi\"9!q\u0003\u0001\u0005\u0002\te\u0011AD7bs\n,W\t\u001f9b]\u0012L5O\u001d\u000b\u0004y\nm\u0001bBA>\u0005+\u0001\r!\u000b\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003y\u0019\u0007.Z2l\u000b:|Wo\u001a5SKBd\u0017nY1t%\u0016\f7\r[(gMN,G\u000f\u0006\u0003\u0003$\t=\u0002cB\u0005\u0003&\u0005M$\u0011F\u0005\u0004\u0005OQ!A\u0002+va2,'\u0007E\u0002\n\u0005WI1A!\f\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011!\u0011\tD!\bA\u0002\tM\u0012A\u0004:fcVL'/\u001a3PM\u001a\u001cX\r\u001e\t\u0004\u0013\tU\u0012b\u0001B\u001c\u0015\t!Aj\u001c8h\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\ta#\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u000b\u0005\u0003g\u0012y\u0004C\u0004\u0003B\te\u0002\u0019A1\u0002\u001b1,\u0017\rZ3s%\u0016\u0004H.[2b\u0011\u001d\u0011)\u0005\u0001C\u0005\u0003#\f!\u0004\u001e:z\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fIJ+\u0017/^3tiNDqA!\u0013\u0001\t\u0003\u0011Y%\u0001\bnCf\u0014Wm\u00155sS:\\\u0017j\u001d:\u0015\u0007q\u0014i\u0005\u0003\u0005\u0003P\t\u001d\u0003\u0019\u0001B\u001a\u0003M\u0011X\r\u001d7jG\u0006l\u0015\r\u001f'bORKW.Z't\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+\nAcZ3u\u001fV$xJZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001cHCBA \u0005/\u0012I\u0006C\u0004\u0003B\tE\u0003\u0019A1\t\u0011\tm#\u0011\u000ba\u0001\u0005g\t\u0001\"\\1y\u0019\u0006<Wj\u001d\u0005\b\u0005?\u0002A\u0011\u0001B1\u0003Y\t\u0007\u000f]3oI6+7o]1hKN$v\u000eT3bI\u0016\u0014HC\u0002B2\u0005S\u0012I\bE\u0002M\u0005KJ1Aa\u001aN\u00055aunZ!qa\u0016tG-\u00138g_\"A!1\u000eB/\u0001\u0004\u0011i'\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\u0011yG!\u001e\u000e\u0005\tE$b\u0001B:\t\u00059Q.Z:tC\u001e,\u0017\u0002\u0002B<\u0005c\u0012ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\b\"\u0003B>\u0005;\u0002\n\u00111\u0001*\u00031\u0011X-];je\u0016$\u0017iY6t\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003\u000b\u0011\"\u001e9eCR,\u0017j\u001d:\u0015\u0007q\u0014\u0019\t\u0003\u0005\u0003\u0006\nu\u0004\u0019AA \u0003\u0019qWm^%te\"9!\u0011\u0012\u0001\u0005\n\u0005E\u0017A\u0006:f[>4X\rU1si&$\u0018n\u001c8NKR\u0014\u0018nY:\t\u000f\t5\u0005\u0001\"\u0011\u0003\u0010\u00061Q-];bYN$B!a\u001d\u0003\u0012\"A!1\u0013BF\u0001\u0004\u0011)*\u0001\u0003uQ\u0006$\bcA\u0005\u0003\u0018&\u0019!\u0011\u0014\u0006\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u001e\u0002!\t%a6\u0002\u0011!\f7\u000f[\"pI\u0016DqA!)\u0001\t\u0003\u0012\u0019+\u0001\u0005u_N#(/\u001b8h)\u0005i\u0002\"\u0003BT\u0001E\u0005I\u0011\u0001BU\u0003q9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1%I\u00164\u0017-\u001e7uIE*\"Aa++\u0007%\u0012ik\u000b\u0002\u00030B!!\u0011\u0017B^\u001b\t\u0011\u0019L\u0003\u0003\u00036\n]\u0016!C;oG\",7m[3e\u0015\r\u0011ILC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B_\u0005g\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\t\rAI\u0001\n\u0003\u0011I+\u0001\u000bhKR\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$H%\r\u0005\n\u0005\u000b\u0004\u0011\u0013!C\u0001\u0005S\u000b\u0001%\u00199qK:$W*Z:tC\u001e,7\u000fV8MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    public final Time kafka$cluster$Partition$$time;
    public final ReplicaManager kafka$cluster$Partition$$replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager kafka$cluster$Partition$$logManager;
    private final ZkUtils zkUtils;
    private final Pool<Object, Replica> kafka$cluster$Partition$$assignedReplicaMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private volatile int kafka$cluster$Partition$$leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile scala.collection.immutable.Set<Replica> inSyncReplicas;
    private int kafka$cluster$Partition$$controllerEpoch;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    public LogManager kafka$cluster$Partition$$logManager() {
        return this.kafka$cluster$Partition$$logManager;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Pool<Object, Replica> kafka$cluster$Partition$$assignedReplicaMap() {
        return this.kafka$cluster$Partition$$assignedReplicaMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    public void kafka$cluster$Partition$$zkVersion_$eq(int x$1) {
        this.kafka$cluster$Partition$$zkVersion = x$1;
    }

    private int kafka$cluster$Partition$$leaderEpoch() {
        return this.kafka$cluster$Partition$$leaderEpoch;
    }

    public void kafka$cluster$Partition$$leaderEpoch_$eq(int x$1) {
        this.kafka$cluster$Partition$$leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public scala.collection.immutable.Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(scala.collection.immutable.Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int kafka$cluster$Partition$$controllerEpoch() {
        return this.kafka$cluster$Partition$$controllerEpoch;
    }

    public void kafka$cluster$Partition$$controllerEpoch_$eq(int x$1) {
        this.kafka$cluster$Partition$$controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.kafka$cluster$Partition$$localBrokerId();
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public boolean isUnderReplicated() {
        Option<Replica> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.leaderReplicaIfLocal();
                    if (!(option instanceof Some)) break block2;
                    bl = this.inSyncReplicas().size() < this.assignedReplicas().size();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public Replica getOrCreateReplica(int replicaId) {
        Option<Replica> option;
        block8: {
            Replica replica;
            block7: {
                Replica replica2;
                block6: {
                    Replica replica3;
                    Option<Replica> replicaOpt = this.getReplica(replicaId);
                    option = replicaOpt;
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    replica = replica3 = (Replica)some.x();
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                if (this.isReplicaLocal(replicaId)) {
                    LogConfig config = LogConfig$.MODULE$.fromProps(this.kafka$cluster$Partition$$logManager().defaultConfig().originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), this.topic()));
                    Log log = this.kafka$cluster$Partition$$logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                    OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.kafka$cluster$Partition$$replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParentFile().getAbsolutePath());
                    Map<TopicAndPartition, Object> offsetMap = checkpoint.read();
                    if (!offsetMap.contains((Object)new TopicAndPartition(this.topic(), this.partitionId()))) {
                        this.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Partition $outer;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("No checkpointed highwatermark is found for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    long offset = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)new TopicAndPartition(this.topic(), this.partitionId()), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    })))).min((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())));
                    Replica localReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, offset, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(localReplica);
                } else {
                    Replica remoteReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
                    replica2 = this.addReplicaIfNotExists(remoteReplica);
                }
                replica = (Replica)this.getReplica(replicaId).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.kafka$cluster$Partition$$assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = this.leaderReplicaIdOpt();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int leaderReplicaId = BoxesRunTime.unboxToInt((Object)some.x());
                    none$ = leaderReplicaId == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.kafka$cluster$Partition$$assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public scala.collection.immutable.Set<Replica> assignedReplicas() {
        return this.kafka$cluster$Partition$$assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.kafka$cluster$Partition$$assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$cluster$Partition$$assignedReplicaMap().clear();
                this.$outer.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Set$.MODULE$.empty());
                this.$outer.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
                try {
                    this.$outer.kafka$cluster$Partition$$logManager().deleteLog(new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId()));
                    this.$outer.kafka$cluster$Partition$$removePartitionMetrics();
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$delete$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error deleting the log for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Throwable>)new Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final IOException e$1;

                        public final IOException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    Runtime.getRuntime().halt(1);
                }
            }

            public /* synthetic */ Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public int getLeaderEpoch() {
        return this.kafka$cluster$Partition$$leaderEpoch();
    }

    public boolean makeLeader(int controllerId, PartitionStateInfo partitionStateInfo, int correlationId) {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new $anonfun$4(this, partitionStateInfo));
        if (tuple2 != null) {
            Tuple2.mcZZ.sp sp2;
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp3 = sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader);
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            boolean isNewLeader2 = sp3._2$mcZ$sp();
            if (leaderHWIncremented2) {
                this.tryCompleteDelayedRequests();
            }
            return isNewLeader2;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean makeFollower(int controllerId, PartitionStateInfo partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, partitionStateInfo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;
            private final PartitionStateInfo partitionStateInfo$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                Set<Object> allReplicas = this.partitionStateInfo$2.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.partitionStateInfo$2.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                int newLeaderBrokerId = leaderAndIsr.leader();
                this.$outer.kafka$cluster$Partition$$controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                allReplicas.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$makeFollower$1 $outer;

                    public final Replica apply(int r) {
                        return this.$outer.kafka$cluster$Partition$$anonfun$$$outer().getOrCreateReplica(r);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ((IterableLike)((Subtractable)this.$outer.assignedReplicas().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Replica x$6) {
                        return x$6.brokerId();
                    }
                }, Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$makeFollower$1 $outer;

                    public final void apply(int x$7) {
                        this.apply$mcVI$sp(x$7);
                    }

                    public void apply$mcVI$sp(int x$7) {
                        this.$outer.kafka$cluster$Partition$$anonfun$$$outer().removeReplica(x$7);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Set$.MODULE$.empty());
                this.$outer.kafka$cluster$Partition$$leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                this.$outer.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                if (this.$outer.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.$outer.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                    bl = false;
                } else {
                    this.$outer.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                    bl = true;
                }
                return bl;
            }

            public /* synthetic */ Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionStateInfo$2 = partitionStateInfo$2;
            }
        }));
    }

    public void updateReplicaLogReadResult(int replicaId, LogReadResult logReadResult) {
        Option<Replica> option = this.getReplica(replicaId);
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica replica = (Replica)some.x();
            replica.updateLogReadResult(logReadResult);
            this.maybeExpandIsr(replicaId);
            this.debug((Function0<String>)new Serializable(this, replicaId, logReadResult){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Partition $outer;
                private final int replicaId$1;
                private final LogReadResult logReadResult$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Recorded replica %d log end offset (LEO) position %d for partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), BoxesRunTime.boxToLong((long)this.logReadResult$1.info().fetchOffsetMetadata().messageOffset()), new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.replicaId$1 = replicaId$1;
                    this.logReadResult$1 = logReadResult$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        None$ none$ = None$.MODULE$;
        Option<Replica> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new NotAssignedReplicaException(new StringOps(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d since the replica is not recognized to be one of the assigned replicas %s for partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset()), ((TraversableOnce)this.assignedReplicas().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Replica x$8) {
                    return x$8.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(","), new TopicAndPartition(this.topic(), this.partitionId())})));
        }
        throw new MatchError(option);
    }

    public void maybeExpandIsr(int replicaId) {
        boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;
            private final int replicaId$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option<Replica> option;
                block6: {
                    boolean bl;
                    block5: {
                        block4: {
                            option = this.$outer.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Replica leaderReplica = (Replica)some.x();
                            Replica replica = (Replica)this.$outer.getReplica(this.replicaId$2).get();
                            LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                            if (!this.$outer.inSyncReplicas().contains((Object)replica) && ((SetLike)this.$outer.assignedReplicas().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Replica x$9) {
                                    return x$9.brokerId();
                                }
                            }, Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId$2)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                                scala.collection.immutable.Set newInSyncReplicas = (scala.collection.immutable.Set)this.$outer.inSyncReplicas().$plus((Object)replica);
                                this.$outer.info((Function0<String>)new Serializable(this, newInSyncReplicas){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$2 $outer;
                                    private final scala.collection.immutable.Set newInSyncReplicas$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Expanding ISR for partition [%s,%d] from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), ((TraversableOnce)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().inSyncReplicas().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Replica x$10) {
                                                return x$10.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$1.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Replica x$11) {
                                                return x$11.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.newInSyncReplicas$1 = newInSyncReplicas$1;
                                    }
                                });
                                this.$outer.kafka$cluster$Partition$$updateIsr((scala.collection.immutable.Set<Replica>)newInSyncReplicas);
                                this.$outer.kafka$cluster$Partition$$replicaManager.isrExpandRate().mark();
                            }
                            bl = this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(leaderReplica);
                            break block5;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError(option);
            }

            public /* synthetic */ Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$2 = replicaId$2;
            }
        }));
        if (leaderHWIncremented) {
            this.tryCompleteDelayedRequests();
        }
    }

    public Tuple2<Object, Object> checkEnoughReplicasReachOffset(long requiredOffset) {
        Option<Replica> option;
        block5: {
            Tuple2 tuple2;
            block4: {
                block3: {
                    option = this.leaderReplicaIfLocal();
                    if (!(option instanceof Some)) break block3;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.x();
                    scala.collection.immutable.Set<Replica> curInSyncReplicas = this.inSyncReplicas();
                    int numAcks = curInSyncReplicas.count((Function1)new Serializable(this, requiredOffset){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Partition $outer;
                        public final long requiredOffset$1;

                        public final boolean apply(Replica r) {
                            boolean bl;
                            if (r.isLocal()) {
                                bl = true;
                            } else if (r.logEndOffset().messageOffset() >= this.requiredOffset$1) {
                                this.$outer.trace((Function0<String>)new Serializable(this, r){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6 $outer;
                                    private final Replica r$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Replica %d of %s-%d received offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.r$1.brokerId()), this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), BoxesRunTime.boxToLong((long)this.$outer.requiredOffset$1)}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.r$1 = r$1;
                                    }
                                });
                                bl = true;
                            } else {
                                bl = false;
                            }
                            return bl;
                        }

                        public /* synthetic */ Partition kafka$cluster$Partition$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.requiredOffset$1 = requiredOffset$1;
                        }
                    });
                    this.trace((Function0<String>)new Serializable(this, numAcks){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Partition $outer;
                        private final int numAcks$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("%d acks satisfied for %s-%d with acks = -1")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.numAcks$1 = numAcks$1;
                        }
                    });
                    Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
                    tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotEnoughReplicasAfterAppendCode()))) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    public boolean kafka$cluster$Partition$$maybeIncrementLeaderHW(Replica leaderReplica) {
        boolean bl;
        scala.collection.immutable.Set allLogEndOffsets = (scala.collection.immutable.Set)this.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Replica x$12) {
                return x$12.logEndOffset();
            }
        }, Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Partition $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("High watermark for partition [%s,%d] updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            bl = true;
        } else {
            this.debug((Function0<String>)new Serializable(this, allLogEndOffsets, newHighWatermark, oldHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Partition $outer;
                private final scala.collection.immutable.Set allLogEndOffsets$1;
                private final LogOffsetMetadata newHighWatermark$1;
                private final LogOffsetMetadata oldHighWatermark$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Skipping update high watermark since Old hw %s is larger than new hw %s for partition [%s,%d]. All leo's are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.oldHighWatermark$1, this.newHighWatermark$1, this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.allLogEndOffsets$1.mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allLogEndOffsets$1 = allLogEndOffsets$1;
                    this.newHighWatermark$1 = newHighWatermark$1;
                    this.oldHighWatermark$1 = oldHighWatermark$1;
                }
            });
            bl = false;
        }
        return bl;
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topic(), this.partitionId());
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedProduce(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, replicaMaxLagTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;
            private final long replicaMaxLagTimeMs$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option<Replica> option;
                block7: {
                    boolean bl;
                    block6: {
                        block5: {
                            boolean bl2;
                            option = this.$outer.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Replica leaderReplica = (Replica)some.x();
                            scala.collection.immutable.Set<Replica> outOfSyncReplicas = this.$outer.getOutOfSyncReplicas(leaderReplica, this.replicaMaxLagTimeMs$1);
                            if (outOfSyncReplicas.size() > 0) {
                                scala.collection.immutable.Set newInSyncReplicas = (scala.collection.immutable.Set)this.$outer.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                                Predef$.MODULE$.assert(newInSyncReplicas.size() > 0);
                                this.$outer.info((Function0<String>)new Serializable(this, newInSyncReplicas){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$3 $outer;
                                    private final scala.collection.immutable.Set newInSyncReplicas$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR for partition [%s,%d] from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), ((TraversableOnce)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().inSyncReplicas().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Replica x$13) {
                                                return x$13.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$2.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Replica x$14) {
                                                return x$14.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.newInSyncReplicas$2 = newInSyncReplicas$2;
                                    }
                                });
                                this.$outer.kafka$cluster$Partition$$updateIsr((scala.collection.immutable.Set<Replica>)newInSyncReplicas);
                                this.$outer.kafka$cluster$Partition$$replicaManager.isrShrinkRate().mark();
                                bl2 = this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(leaderReplica);
                            } else {
                                bl2 = false;
                            }
                            bl = bl2;
                            break block6;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError(option);
            }

            public /* synthetic */ Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaMaxLagTimeMs$1 = replicaMaxLagTimeMs$1;
            }
        }));
        if (leaderHWIncremented) {
            this.tryCompleteDelayedRequests();
        }
    }

    public scala.collection.immutable.Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        LogOffsetMetadata leaderLogEndOffset = leaderReplica.logEndOffset();
        scala.collection.immutable.Set candidateReplicas = (scala.collection.immutable.Set)this.inSyncReplicas().$minus((Object)leaderReplica);
        scala.collection.immutable.Set laggingReplicas = (scala.collection.immutable.Set)candidateReplicas.filter((Function1)new Serializable(this, maxLagMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;
            private final long maxLagMs$1;

            public final boolean apply(Replica r) {
                return this.$outer.kafka$cluster$Partition$$time.milliseconds() - r.lastCaughtUpTimeMs() > this.maxLagMs$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxLagMs$1 = maxLagMs$1;
            }
        });
        if (laggingReplicas.size() > 0) {
            this.debug((Function0<String>)new Serializable(this, laggingReplicas){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Partition $outer;
                private final scala.collection.immutable.Set laggingReplicas$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Lagging replicas for partition %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId()), ((TraversableOnce)this.laggingReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Replica x$15) {
                            return x$15.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.laggingReplicas$1 = laggingReplicas$1;
                }
            });
        }
        return laggingReplicas;
    }

    public LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages, int requiredAcks) {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), new $anonfun$9(this, messages, requiredAcks));
        if (tuple2 != null) {
            Tuple2 tuple22;
            LogAppendInfo info = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            LogAppendInfo info2 = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (leaderHWIncremented2) {
                this.tryCompleteDelayedRequests();
            }
            return info2;
        }
        throw new MatchError((Object)tuple2);
    }

    public int appendMessagesToLeader$default$2() {
        return 0;
    }

    public void kafka$cluster$Partition$$updateIsr(scala.collection.immutable.Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.kafka$cluster$Partition$$leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica r) {
                return r.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), this.topic(), this.partitionId(), newLeaderAndIsr, this.kafka$cluster$Partition$$controllerEpoch(), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2.mcZI.sp sp2;
            boolean updateSucceeded = tuple2._1$mcZ$sp();
            int newVersion = tuple2._2$mcI$sp();
            Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
            boolean updateSucceeded2 = sp3._1$mcZ$sp();
            int newVersion2 = sp3._2$mcI$sp();
            if (updateSucceeded2) {
                this.kafka$cluster$Partition$$replicaManager.recordIsrChange(new TopicAndPartition(this.topic(), this.partitionId()));
                this.inSyncReplicas_$eq(newIsr);
                this.kafka$cluster$Partition$$zkVersion_$eq(newVersion2);
                this.trace((Function0<String>)new Serializable(this, newIsr){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Partition $outer;
                    private final scala.collection.immutable.Set newIsr$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newIsr$1.mkString(","), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newIsr$1 = newIsr$1;
                    }
                });
            } else {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Partition $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public void kafka$cluster$Partition$$removePartitionMetrics() {
        this.removeMetric("UnderReplicated", (Map<String, String>)this.tags());
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            Partition other = (Partition)that;
            return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
        partitionString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
        partitionString.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
        partitionString.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.kafka$cluster$Partition$$assignedReplicaMap().keys().mkString(",")).toString());
        partitionString.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$18) {
                return x$18.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
        return partitionString.toString();
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.kafka$cluster$Partition$$time = time;
        this.kafka$cluster$Partition$$replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.kafka$cluster$Partition$$logManager = replicaManager.logManager();
        this.zkUtils = replicaManager.zkUtils();
        this.kafka$cluster$Partition$$assignedReplicaMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.kafka$cluster$Partition$$leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.kafka$cluster$Partition$$controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        this.newGauge("UnderReplicated", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
    }
}

