/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.util.Bits;

public abstract class NormsConsumer
implements Closeable {
    protected NormsConsumer() {
    }

    public abstract void addNormsField(FieldInfo var1, Iterable<Number> var2) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (NormsProducer normsProducer : mergeState.normsProducers) {
            if (normsProducer == null) continue;
            normsProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            if (!mergeFieldInfo.hasNorms()) continue;
            ArrayList<NumericDocValues> toMerge = new ArrayList<NumericDocValues>();
            for (int i = 0; i < mergeState.normsProducers.length; ++i) {
                FieldInfo fieldInfo;
                NormsProducer normsProducer = mergeState.normsProducers[i];
                NumericDocValues norms = null;
                if (normsProducer != null && (fieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.hasNorms()) {
                    norms = normsProducer.getNorms(fieldInfo);
                }
                if (norms == null) {
                    norms = DocValues.emptyNumeric();
                }
                toMerge.add(norms);
            }
            this.mergeNormsField(mergeFieldInfo, mergeState, toMerge);
        }
    }

    public void mergeNormsField(FieldInfo fieldInfo, final MergeState mergeState, final List<NumericDocValues> toMerge) throws IOException {
        this.addNormsField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    int maxDoc;
                    NumericDocValues currentValues;
                    Bits currentLiveDocs;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != toMerge.size()) {
                            if (this.currentValues == null || this.docIDUpto == this.maxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < toMerge.size()) {
                                    this.currentValues = (NumericDocValues)toMerge.get(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.maxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                this.nextValue = this.currentValues.get(this.docIDUpto);
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }
}

