/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private final int minimumNumberShouldMatch;
    private final List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    private BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.getOccur()).add(clause.getQuery());
        }
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    Collection<Query> getClauses(BooleanClause.Occur occur) {
        return this.clauseSets.get((Object)occur);
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    private BooleanQuery rewriteNoScoring() {
        Builder newQuery = new Builder();
        newQuery.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        for (BooleanClause clause : this.clauses) {
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                newQuery.add(clause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            newQuery.add(clause);
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        BooleanQuery query = this;
        if (!needsScores) {
            query = this.rewriteNoScoring();
        }
        return new BooleanWeight(query, searcher, needsScores, boost);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Collection<Query> filters;
        boolean bl;
        boolean bl2;
        if (this.clauses.size() == 0) {
            return new MatchNoDocsQuery("empty BooleanQuery");
        }
        if (this.clauses.size() == 1) {
            BooleanClause c = this.clauses.get(0);
            Query query = c.getQuery();
            if (this.minimumNumberShouldMatch == 1 && c.getOccur() == BooleanClause.Occur.SHOULD) {
                return query;
            }
            if (this.minimumNumberShouldMatch == 0) {
                switch (c.getOccur()) {
                    case SHOULD: 
                    case MUST: {
                        return query;
                    }
                    case FILTER: {
                        return new BoostQuery(new ConstantScoreQuery(query), 0.0f);
                    }
                    case MUST_NOT: {
                        return new MatchNoDocsQuery("pure negative BooleanQuery");
                    }
                }
                throw new AssertionError();
            }
        }
        Builder builder = new Builder();
        builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause booleanClause : this) {
            Query query = booleanClause.getQuery();
            Query rewritten = query.rewrite(reader);
            if (rewritten != query) {
                actuallyRewritten = true;
            }
            builder.add(rewritten, booleanClause.getOccur());
        }
        if (actuallyRewritten) {
            return builder.build();
        }
        int clauseCount = 0;
        for (Collection<Query> collection : this.clauseSets.values()) {
            clauseCount += collection.size();
        }
        if (clauseCount != this.clauses.size()) {
            Builder rewritten = new Builder();
            rewritten.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            for (Map.Entry<BooleanClause.Occur, Collection<Query>> entry : this.clauseSets.entrySet()) {
                BooleanClause.Occur occur = entry.getKey();
                for (Query query : entry.getValue()) {
                    rewritten.add(query, occur);
                }
            }
            return rewritten.build();
        }
        Collection<Query> mustNotClauses = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
        if (!mustNotClauses.isEmpty()) {
            Predicate<Query> p = this.clauseSets.get((Object)BooleanClause.Occur.MUST)::contains;
            if (mustNotClauses.stream().anyMatch(p.or(this.clauseSets.get((Object)BooleanClause.Occur.FILTER)::contains))) {
                return new MatchNoDocsQuery("FILTER or MUST clause also in MUST_NOT");
            }
            if (mustNotClauses.contains(new MatchAllDocsQuery())) {
                return new MatchNoDocsQuery("MUST_NOT clause is MatchAllDocsQuery");
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0 && (bl2 = (bl = (filters = new HashSet<Query>(this.clauseSets.get((Object)BooleanClause.Occur.FILTER))).remove(new MatchAllDocsQuery())) | filters.removeAll(this.clauseSets.get((Object)BooleanClause.Occur.MUST)))) {
            Builder builder2 = new Builder();
            builder2.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
            for (BooleanClause clause : this.clauses) {
                if (clause.getOccur() == BooleanClause.Occur.FILTER) continue;
                builder2.add(clause);
            }
            for (Query filter : filters) {
                builder2.add(filter, BooleanClause.Occur.FILTER);
            }
            return builder2.build();
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            filters = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
            Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            HashSet<Query> hashSet = new HashSet<Query>(filters);
            hashSet.retainAll(collection);
            if (!hashSet.isEmpty()) {
                Builder builder3 = new Builder();
                int minShouldMatch = this.getMinimumNumberShouldMatch();
                for (BooleanClause clause : this.clauses) {
                    if (hashSet.contains(clause.getQuery())) {
                        if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                        builder3.add(new BooleanClause(clause.getQuery(), BooleanClause.Occur.MUST));
                        --minShouldMatch;
                        continue;
                    }
                    builder3.add(clause);
                }
                builder3.setMinimumNumberShouldMatch(Math.max(0, minShouldMatch));
                return builder3.build();
            }
        }
        Collection<Query> musts = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        if (musts.size() == 1 && collection.size() > 0) {
            void var5_25;
            Query query = musts.iterator().next();
            float boost = 1.0f;
            if (query instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query;
                Query query2 = boostQuery.getQuery();
                boost = boostQuery.getBoost();
            }
            if (var5_25.getClass() == MatchAllDocsQuery.class) {
                Builder builder4 = new Builder();
                for (BooleanClause clause : this.clauses) {
                    switch (clause.getOccur()) {
                        case FILTER: 
                        case MUST_NOT: {
                            builder4.add(clause);
                            break;
                        }
                    }
                }
                Query rewritten = builder4.build();
                rewritten = new ConstantScoreQuery(rewritten);
                if (boost != 1.0f) {
                    rewritten = new BoostQuery(rewritten, boost);
                }
                builder4 = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch()).add(rewritten, BooleanClause.Occur.MUST);
                for (Query query3 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                    builder4.add(query3, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder4.build();
                return rewritten;
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((BooleanQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(BooleanQuery other) {
        return this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.clauseSets.equals(other.clauseSets);
    }

    private int computeHashCode() {
        int hashCode = Objects.hash(this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return this.hashCode;
    }

    public static class Builder {
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setMinimumNumberShouldMatch(int min) {
            this.minimumNumberShouldMatch = min;
            return this;
        }

        public Builder add(BooleanClause clause) {
            if (this.clauses.size() >= maxClauseCount) {
                throw new TooManyClauses();
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            return this.add(new BooleanClause(query, occur));
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

