/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.markers;

import java.io.File;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.markers.DefaultFileMarkerHandler;
import org.codehaus.plexus.util.StringUtils;

public class UnpackFileMarkerHandler
extends DefaultFileMarkerHandler {
    protected ArtifactItem artifactItem;

    public UnpackFileMarkerHandler(File markerFilesDirectory) {
        super(markerFilesDirectory);
    }

    public UnpackFileMarkerHandler(ArtifactItem artifactItem, File markerFilesDirectory) {
        this(markerFilesDirectory);
        this.setArtifactItem(artifactItem);
    }

    protected File getMarkerFile() {
        File markerFile;
        if (this.artifactItem == null || StringUtils.isEmpty((String)this.artifactItem.getIncludes()) && StringUtils.isEmpty((String)this.artifactItem.getExcludes())) {
            markerFile = super.getMarkerFile();
        } else {
            int includeExcludeHash = 0;
            if (StringUtils.isNotEmpty((String)this.artifactItem.getIncludes())) {
                includeExcludeHash += this.artifactItem.getIncludes().hashCode();
            }
            if (StringUtils.isNotEmpty((String)this.artifactItem.getExcludes())) {
                includeExcludeHash += this.artifactItem.getExcludes().hashCode();
            }
            markerFile = new File(this.markerFilesDirectory, this.artifact.getId().replace(':', '-') + includeExcludeHash);
        }
        return markerFile;
    }

    public void setArtifactItem(ArtifactItem artifactItem) {
        this.artifactItem = artifactItem;
        if (this.artifactItem != null) {
            this.setArtifact(this.artifactItem.getArtifact());
        }
    }

    public ArtifactItem getArtifactItem() {
        return this.artifactItem;
    }
}

