/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.jmx;

import java.net.SocketAddress;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.integration.jmx.IoServiceManagerMBean;
import org.apache.mina.management.StatCollector;

public class IoServiceManager
implements IoServiceManagerMBean {
    private IoService service;
    private StatCollector collector = null;

    public IoServiceManager(IoService service) {
        this.service = service;
    }

    public int getManagedSessionCount() {
        int count = 0;
        for (SocketAddress element : this.service.getManagedServiceAddresses()) {
            count += this.service.getManagedSessions(element).size();
        }
        return count;
    }

    public void startCollectingStats(int millisecondsPolling) {
        if (this.collector != null && this.collector.isRunning()) {
            throw new RuntimeException("Already collecting stats");
        }
        this.collector = new StatCollector(this.service, millisecondsPolling);
        this.collector.start();
    }

    public void stopCollectingStats() {
        if (this.collector != null && this.collector.isRunning()) {
            this.collector.stop();
        }
    }

    public float getTotalByteReadThroughput() {
        return this.collector.getBytesReadThroughput();
    }

    public float getTotalByteWrittenThroughput() {
        return this.collector.getBytesWrittenThroughput();
    }

    public float getTotalMessageReadThroughput() {
        return this.collector.getMsgReadThroughput();
    }

    public float getTotalMessageWrittenThroughput() {
        return this.collector.getMsgWrittenThroughput();
    }

    public float getAverageByteReadThroughput() {
        return this.collector.getBytesReadThroughput() / (float)this.collector.getSessionCount();
    }

    public float getAverageByteWrittenThroughput() {
        return this.collector.getBytesWrittenThroughput() / (float)this.collector.getSessionCount();
    }

    public float getAverageMessageReadThroughput() {
        return this.collector.getMsgReadThroughput() / (float)this.collector.getSessionCount();
    }

    public float getAverageMessageWrittenThroughput() {
        return this.collector.getMsgWrittenThroughput() / (float)this.collector.getSessionCount();
    }

    public void closeAllSessions() {
        for (SocketAddress element : this.service.getManagedServiceAddresses()) {
            for (IoSession session : this.service.getManagedSessions(element)) {
                session.close();
            }
        }
    }
}

