/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    private Citations() {
    }

    public static boolean isEPSG(String string, String string2) {
        return "EPSG".equalsIgnoreCase(string2) && ("IOGP".equalsIgnoreCase(string) || "OGP".equalsIgnoreCase(string) || "EPSG".equalsIgnoreCase(string));
    }

    public static <E> Iterator<E> iterator(Collection<E> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator() : null;
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private static String toString(InternationalString internationalString) {
        return internationalString != null && !Citations.isDeprecated(internationalString) ? CharSequences.trimWhitespaces(internationalString.toString(Locale.ROOT)) : null;
    }

    public static boolean equalsFiltered(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequences.equalsFiltered(charSequence, charSequence2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            InternationalString internationalString = citation2.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(Locale.ROOT);
                    if (Citations.titleMatches(citation, string)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (!Objects.equals(string2, string) && Citations.titleMatches(citation, string2)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, CharSequence charSequence) {
        if (citation != null && charSequence != null) {
            InternationalString internationalString = citation.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(Locale.ROOT);
                    if (Citations.equalsFiltered(string, charSequence)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (!Objects.equals(string2, string) && Citations.equalsFiltered(string2, charSequence)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            Iterator iterator = Citations.iterator(citation2.getIdentifiers());
            if (iterator == null) {
                iterator = Citations.iterator(citation.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(citation, citation2);
                }
                citation = citation2;
            }
            do {
                Identifier identifier;
                if ((identifier = (Identifier)iterator.next()) == null || !Citations.identifierMatches(citation, identifier, identifier.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Identifier identifier, CharSequence charSequence) {
        if (citation != null && charSequence != null) {
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator == null) {
                return Citations.titleMatches(citation, charSequence);
            }
            while (iterator.hasNext()) {
                String string;
                String string2;
                Identifier identifier2 = (Identifier)iterator.next();
                if (identifier2 == null || !Citations.equalsFiltered(charSequence, identifier2.getCode())) continue;
                if (identifier instanceof ReferenceIdentifier && (string2 = ((ReferenceIdentifier)identifier).getCodeSpace()) != null && identifier2 instanceof ReferenceIdentifier && (string = ((ReferenceIdentifier)identifier2).getCodeSpace()) != null) {
                    return Citations.equalsFiltered(string2, string);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean authorityMatches(Identifier identifier, Citation citation, String string) {
        Object object;
        if (citation != null && (object = identifier.getAuthority()) != null) {
            return Citations.identifierMatches(citation, object);
        }
        if (string != null && identifier instanceof ReferenceIdentifier && (object = ((ReferenceIdentifier)identifier).getCodeSpace()) != null) {
            return CharSequences.equalsFiltered(string, (CharSequence)object, Characters.Filter.UNICODE_IDENTIFIER, true);
        }
        return false;
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends Identifier> iterable, Iterable<? extends Identifier> iterable2) {
        if (iterable != null && iterable2 != null) {
            boolean bl = false;
            for (Identifier identifier : iterable) {
                Citation citation = identifier.getAuthority();
                String string = identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getCodeSpace() : null;
                for (Identifier identifier2 : iterable2) {
                    if (!Citations.authorityMatches(identifier, citation, string)) continue;
                    if (CharSequences.equalsFiltered(identifier.getCode(), identifier2.getCode(), Characters.Filter.UNICODE_IDENTIFIER, true)) {
                        return Boolean.TRUE;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String getIdentifier(Citation citation, boolean bl) {
        if (citation != null) {
            String string;
            Object object;
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String string4;
                    object = (Identifier)iterator.next();
                    if (object == null || Citations.isDeprecated(object) || (string = CharSequences.trimWhitespaces(object.getCode())) == null || string.isEmpty()) continue;
                    String string5 = string4 = object instanceof ReferenceIdentifier ? CharSequences.trimWhitespaces(((ReferenceIdentifier)object).getCodeSpace()) : null;
                    if (string4 == null || string4.isEmpty()) {
                        string4 = null;
                        bl2 = CharSequences.isUnicodeIdentifier(string);
                    } else {
                        bl2 = CharSequences.isUnicodeIdentifier(string4);
                        if (bl2) {
                            int n;
                            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                                n = string.codePointAt(i);
                                if (Character.isUnicodeIdentifierPart(n)) continue;
                                bl2 = false;
                                break;
                            }
                        }
                    }
                    if (string2 != null && !bl2) continue;
                    string2 = string;
                    string3 = string4;
                    if (!bl2) continue;
                    break;
                }
            }
            if (string2 == null) {
                string2 = Citations.toString(citation.getTitle());
                if (string2 != null) {
                    if (string2.isEmpty()) {
                        string2 = null;
                    } else {
                        bl2 = CharSequences.isUnicodeIdentifier(string2);
                    }
                }
                if (!bl2 && (object = Citations.iterator(citation.getAlternateTitles())) != null) {
                    while (object.hasNext()) {
                        string = Citations.toString((InternationalString)object.next());
                        if (string == null || string.isEmpty()) continue;
                        bl2 = CharSequences.isUnicodeIdentifier(string);
                        if (string2 != null && !bl2) continue;
                        string2 = string;
                        if (!bl2) continue;
                        break;
                    }
                }
            }
            if (bl2 || !bl) {
                if (string3 != null && !Citations.isEPSG(string3, string2)) {
                    return string3 + (bl ? (char)'_' : ':') + string2;
                }
                return string2;
            }
        }
        return null;
    }

    public static String getUnicodeIdentifier(Citation citation) {
        String string = Citations.getIdentifier(citation, true);
        if (string != null) {
            int n;
            int n2 = string.length();
            for (int i = 0; i < n2; i += n) {
                int n3 = string.codePointAt(i);
                n = Character.charCount(n3);
                if (!Character.isIdentifierIgnorable(n3)) continue;
                StringBuilder stringBuilder = new StringBuilder(n2 - n).append(string, 0, i);
                while ((i += n) < n2) {
                    n3 = string.codePointAt(i);
                    n = Character.charCount(n3);
                    if (Character.isIdentifierIgnorable(n3)) continue;
                    stringBuilder.appendCodePoint(n3);
                }
                return stringBuilder.toString();
            }
        }
        return string;
    }

    public static String getCodeSpace(Citation citation) {
        if (citation instanceof IdentifierSpace) {
            return ((IdentifierSpace)citation).getName();
        }
        return Citations.getUnicodeIdentifier(citation);
    }
}

