/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.LineAppender;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class TreeTableFormat
extends TabularFormat<TreeTable> {
    private static final long serialVersionUID = 147992015470098561L;
    static final TreeTableFormat INSTANCE = new TreeTableFormat(null, null);
    private Map<TableColumn<?>, Integer> columnIndices;
    private int indentation = 4;
    private int verticalLinePosition = 2;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private transient Map<Object, Object> parentObjects;

    public TreeTableFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.beforeFill = "\u2026\u2026";
        this.fillCharacter = (char)8230;
        this.omitTrailingNulls = true;
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    @Override
    public final Class<TreeTable> getValueType() {
        return TreeTable.class;
    }

    public TableColumn<?>[] getColumns() {
        return this.columnIndices != null ? DefaultTreeTable.getColumns(this.columnIndices) : null;
    }

    public void setColumns(TableColumn<?> ... tableColumnArray) throws IllegalArgumentException {
        if (tableColumnArray == null) {
            this.columnIndices = null;
        } else {
            if (tableColumnArray.length == 0) {
                throw new IllegalArgumentException(Errors.format((short)20, "columns"));
            }
            this.columnIndices = DefaultTreeTable.createColumnIndices(tableColumnArray);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("indentation", n);
        this.indentation = n;
        if (this.verticalLinePosition > n) {
            this.verticalLinePosition = n;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("verticalLinePosition", 0, this.indentation, n);
        this.verticalLinePosition = n;
        this.clearTreeSymbols();
    }

    final Locale getDisplayLocale() {
        return this.getLocale();
    }

    final Format[] getFormats(TableColumn<?>[] tableColumnArray, boolean bl) throws IllegalStateException {
        Format[] formatArray = new Format[tableColumnArray.length];
        for (int i = 0; i < formatArray.length; ++i) {
            Class<String> clazz = tableColumnArray[i].getElementType();
            formatArray[i] = this.getFormat(clazz);
            if (formatArray[i] != null || !bl || clazz.isAssignableFrom(String.class)) continue;
            throw new IllegalStateException(Errors.format((short)126, clazz));
        }
        return formatArray;
    }

    @Override
    public TreeTable parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        int n;
        Matcher matcher = this.getColumnSeparatorMatcher(charSequence);
        int n2 = charSequence.length();
        int n3 = parsePosition.getIndex();
        int n4 = 0;
        int[] nArray = new int[16];
        TreeTable.Node node = null;
        DefaultTreeTable.Node node2 = null;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(this.columnIndices != null ? this.columnIndices : TableColumn.NAME_MAP);
        TableColumn<?>[] tableColumnArray = DefaultTreeTable.getColumns(defaultTreeTable.columnIndices);
        Format[] formatArray = this.getFormats(tableColumnArray, true);
        do {
            int n5;
            int n6;
            int n7;
            char c;
            int n8;
            for (n8 = n = CharSequences.indexOfLineStart(charSequence, 1, n3); n8 > n3 && ((c = charSequence.charAt(n8 - 1)) == '\r' || c == '\n'); --n8) {
            }
            c = '\u0000';
            for (n6 = n3; n6 < n8; n6 += Character.charCount(n7)) {
                n7 = Character.codePointAt(charSequence, n6);
                if (Character.isSpaceChar(n7)) continue;
                c = '\u0001';
                if ("\u2500\u2502\u2514\u251c".indexOf(n7) < 0) break;
            }
            if (c == '\u0000') break;
            n7 = n6;
            n6 = CharSequences.skipTrailingWhitespaces(charSequence, n3, n6) - n3;
            DefaultTreeTable.Node node3 = new DefaultTreeTable.Node(defaultTreeTable);
            try {
                matcher.region(n7, n8);
                for (n5 = 0; n5 < tableColumnArray.length; ++n5) {
                    boolean bl = matcher.find();
                    int n9 = bl ? matcher.start() : n8;
                    int n10 = CharSequences.skipTrailingWhitespaces(charSequence, n7 = CharSequences.skipLeadingWhitespaces(charSequence, n7, n9), n9);
                    if (n10 > n7) {
                        this.parseValue(node3, tableColumnArray[n5], formatArray[n5], charSequence.subSequence(n7, n10).toString());
                    }
                    if (bl) {
                        n7 = matcher.end();
                        continue;
                    }
                    break;
                }
            }
            catch (ParseException parseException) {
                parsePosition.setErrorIndex(n7);
                throw parseException;
            }
            if (node2 == null) {
                nArray[0] = n6;
                node2 = node3;
            } else {
                while (n6 < (n5 = nArray[n4])) {
                    if (--n4 < 0) {
                        parsePosition.setErrorIndex(n3);
                        throw new LocalizedParseException(this.getDisplayLocale(), 75, new Object[]{node3}, 0);
                    }
                    node = node.getParent();
                }
                if (n6 == n5) {
                    TreeTable.Node node4 = node.getParent();
                    if (node4 == null) {
                        parsePosition.setErrorIndex(n3);
                        throw new LocalizedParseException(this.getDisplayLocale(), 75, new Object[]{node3}, 0);
                    }
                    node4.getChildren().add(node3);
                } else if (n6 > n5) {
                    node.getChildren().add(node3);
                    if (++n4 == nArray.length) {
                        nArray = Arrays.copyOf(nArray, n4 * 2);
                    }
                    nArray[n4] = n6;
                }
            }
            node = node3;
        } while ((n3 = n) != n2);
        if (node2 == null) {
            return null;
        }
        parsePosition.setIndex(n3);
        defaultTreeTable.setRoot(node2);
        return defaultTreeTable;
    }

    private <V> void parseValue(TreeTable.Node node, TableColumn<V> tableColumn, Format format, String string) throws ParseException {
        Object object = format != null ? format.parseObject(string) : string;
        node.setValue(tableColumn, tableColumn.getElementType().cast(object));
    }

    private void createTreeSymbols() {
        int n = this.indentation;
        int n2 = this.verticalLinePosition;
        char[] cArray = new char[n];
        block6: for (int i = 0; i < 4; ++i) {
            char c;
            int n3;
            if ((i & 2) == 0) {
                n3 = (i & 1) == 0 ? 160 : 9474;
                c = '\u00a0';
            } else {
                n3 = (i & 1) == 0 ? 9492 : 9500;
                c = '\u2500';
            }
            Arrays.fill(cArray, 0, n2, '\u00a0');
            cArray[n2] = n3;
            Arrays.fill(cArray, n2 + 1, n, c);
            String string = String.valueOf(cArray);
            switch (i) {
                case 0: {
                    this.treeBlank = string;
                    continue block6;
                }
                case 1: {
                    this.treeLine = string;
                    continue block6;
                }
                case 2: {
                    this.treeEnd = string;
                    continue block6;
                }
                case 3: {
                    this.treeCross = string;
                    continue block6;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
        }
    }

    final String getTreeSymbols(boolean bl, boolean bl2) {
        return bl ? (bl2 ? this.treeBlank : this.treeLine) : (bl2 ? this.treeEnd : this.treeCross);
    }

    final void writeColumnSeparator(Appendable appendable) throws IOException {
        ((TableAppender)appendable.append(this.beforeFill)).nextColumn(this.fillCharacter);
        appendable.append(this.columnSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(TreeTable treeTable, Appendable appendable) throws IOException {
        Object object;
        TableColumn<?>[] tableColumnArray;
        ArgumentChecks.ensureNonNull("tree", treeTable);
        if (this.treeBlank == null) {
            this.createTreeSymbols();
        }
        if (this.columnIndices != null) {
            tableColumnArray = DefaultTreeTable.getColumns(this.columnIndices);
        } else {
            object = treeTable.getColumns();
            tableColumnArray = object.toArray(new TableColumn[object.size()]);
        }
        if (this.parentObjects == null) {
            this.parentObjects = new IdentityHashMap<Object, Object>();
        }
        try {
            object = new Writer(appendable, tableColumnArray, this.parentObjects);
            ((Writer)object).format(treeTable.getRoot(), 0);
            ((LineAppender)object).flush();
        }
        finally {
            this.parentObjects.clear();
        }
    }

    private final class Writer
    extends LineAppender {
        private final TableColumn<?>[] columns;
        private final Format[] formats;
        private final Object[] values;
        private boolean[] isLast;
        private final Map<Object, Object> parentObjects;

        Writer(Appendable appendable, TableColumn<?>[] tableColumnArray, Map<Object, Object> map) {
            super(tableColumnArray.length >= 2 ? new TableAppender(appendable, "") : appendable);
            this.columns = tableColumnArray;
            this.formats = TreeTableFormat.this.getFormats(tableColumnArray, false);
            this.values = new Object[tableColumnArray.length];
            this.isLast = new boolean[8];
            this.parentObjects = map;
            this.setTabulationExpanded(true);
            this.setLineSeparator(" \u00b6 ");
        }

        private void formatValue(Format format, Object object) throws IOException {
            CharSequence charSequence;
            if (object == null) {
                charSequence = " ";
            } else if (format != null) {
                if (format instanceof CompoundFormat) {
                    this.formatValue((CompoundFormat)format, object);
                    return;
                }
                charSequence = format.format(object);
            } else {
                Locale locale;
                Locale locale2;
                Locale locale3;
                charSequence = object instanceof InternationalString ? ((InternationalString)object).toString(TreeTableFormat.this.getDisplayLocale()) : (object instanceof CharSequence ? object.toString() : (object instanceof CodeList ? Types.getCodeTitle((CodeList)object).toString(TreeTableFormat.this.getDisplayLocale()) : (object instanceof Enum ? CharSequences.upperCaseToSentence(((Enum)object).name()) : (object instanceof Locale ? ((locale3 = TreeTableFormat.this.getDisplayLocale()) != Locale.ROOT ? ((Locale)object).getDisplayName(locale3) : object.toString()) : (object instanceof TimeZone ? ((locale2 = TreeTableFormat.this.getDisplayLocale()) != Locale.ROOT ? ((TimeZone)object).getDisplayName(locale2) : ((TimeZone)object).getID()) : (object instanceof Charset ? ((locale = TreeTableFormat.this.getDisplayLocale()) != Locale.ROOT ? ((Charset)object).displayName(locale) : ((Charset)object).name()) : ((format = TreeTableFormat.this.getFormat(object.getClass())) != null ? format.format(object) : object.toString())))))));
            }
            this.append(charSequence);
        }

        private <V> void formatValue(CompoundFormat<V> compoundFormat, Object object) throws IOException {
            compoundFormat.format(compoundFormat.getValueType().cast(object), this);
        }

        final void format(TreeTable.Node node, int n) throws IOException {
            Object object;
            int n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                this.out.append(TreeTableFormat.this.getTreeSymbols(n3 != n - 1, this.isLast[n3]));
            }
            n3 = 0;
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                this.values[n2] = node.getValue(this.columns[n2]);
                if (this.values[n2] == null) continue;
                n3 = n2;
            }
            if (!TreeTableFormat.this.omitTrailingNulls) {
                n3 = this.values.length - 1;
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                if (n2 != 0) {
                    TreeTableFormat.this.writeColumnSeparator(this.out);
                }
                this.formatValue(this.formats[n2], this.values[n2]);
                this.clear();
            }
            this.out.append(TreeTableFormat.this.lineSeparator);
            if (n >= this.isLast.length) {
                this.isLast = Arrays.copyOf(this.isLast, n * 2);
            }
            if (this.parentObjects.put(object = node.getUserObject(), object) == null) {
                Iterator<TreeTable.Node> iterator = node.getChildren().iterator();
                boolean bl = iterator.hasNext();
                while (bl) {
                    TreeTable.Node node2 = iterator.next();
                    bl = iterator.hasNext();
                    this.isLast[n] = !bl;
                    this.format(node2, n + 1);
                }
                this.parentObjects.remove(object);
            } else {
                for (int i = 0; i < n; ++i) {
                    this.out.append(TreeTableFormat.this.getTreeSymbols(true, this.isLast[i]));
                }
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                this.out.append('(').append(Vocabulary.getResources(locale).getString((short)12).toLowerCase(locale)).append(')').append(TreeTableFormat.this.lineSeparator);
            }
        }
    }
}

