/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.WeakEntry;

public class WeakHashSet<E>
extends AbstractSet<E>
implements CheckedContainer<E> {
    private Entry[] table;
    private int count;
    private final Class<E> elementType;
    private final boolean mayContainArrays;
    private transient long lastTimeNormalCapacity;
    private static final int REMOVE = -1;
    private static final int GET = 0;
    private static final int ADD = 1;
    private static final int INTERN = 2;

    public WeakHashSet(Class<E> clazz) {
        this.elementType = clazz;
        this.mayContainArrays = clazz.isArray() || clazz.equals(Object.class);
        this.lastTimeNormalCapacity = System.nanoTime();
        Entry[] entryArray = (Entry[])Array.newInstance(Entry.class, 7);
        this.table = entryArray;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.isValid());
        int n = this.table.length;
        if (entry.removeFrom(this.table, entry.hash % n)) {
            long l;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(n) && (l = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count, "remove");
                this.lastTimeNormalCapacity = l;
                assert (this.isValid());
            }
        }
    }

    private boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    @Override
    public synchronized boolean add(E e) throws NullArgumentException {
        ArgumentChecks.ensureNonNull("element", e);
        return this.intern(e, 1) == null;
    }

    @Override
    public synchronized boolean remove(Object object) {
        return this.intern(object, -1) != null;
    }

    public synchronized E get(Object object) {
        return this.intern(object, 0);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.intern(object, 0) != null;
    }

    public synchronized <T extends E> T unique(T t) {
        return (T)this.intern(t, 2);
    }

    private E intern(Object object, int n) {
        assert (this.isValid());
        if (object != null) {
            Entry[] entryArray = this.table;
            int n2 = (this.mayContainArrays ? Utilities.deepHashCode(object) : object.hashCode()) & Integer.MAX_VALUE;
            int n3 = n2 % entryArray.length;
            Entry entry = entryArray[n3];
            while (entry != null) {
                Object t = entry.get();
                if (this.mayContainArrays ? Objects.deepEquals(t, object) : object.equals(t)) {
                    if (n == -1) {
                        entry.dispose();
                    }
                    return (E)t;
                }
                entry = (Entry)entry.next;
            }
            if (n >= 1) {
                if (++this.count >= WeakEntry.lowerCapacityThreshold(entryArray.length)) {
                    if (this.count > WeakEntry.upperCapacityThreshold(entryArray.length)) {
                        this.table = entryArray = (Entry[])WeakEntry.rehash(entryArray, this.count, "add");
                        n3 = n2 % entryArray.length;
                    }
                    this.lastTimeNormalCapacity = System.nanoTime();
                }
                entry = this.elementType.cast(object);
                entryArray[n3] = new Entry(entry, entryArray[n3], n2);
                assert (this.isValid());
                if (n == 2) {
                    return (E)entry;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized E[] toArray() {
        assert (this.isValid());
        Object[] objectArray = (Object[])Array.newInstance(this.elementType, this.count);
        int n = 0;
        for (Entry entry : this.table) {
            while (entry != null) {
                objectArray[n] = entry.get();
                if (objectArray[n] != null) {
                    ++n;
                }
                entry = (Entry)entry.next;
            }
        }
        return ArraysExt.resize(objectArray, n);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakEntry<E> {
        Entry(E e, Entry entry, int n) {
            super(e, entry, n);
        }

        @Override
        public void dispose() {
            super.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

