/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.QuietLogRecord;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;

public class WarningListeners<S>
implements Localized {
    private final S source;
    private WarningListener<? super S>[] listeners;

    WarningListeners() {
        this.source = null;
    }

    public WarningListeners(S s) {
        ArgumentChecks.ensureNonNull("source", s);
        this.source = s;
    }

    @Override
    public Locale getLocale() {
        return this.source instanceof Localized ? ((Localized)this.source).getLocale() : null;
    }

    public Logger getLogger() {
        return Logging.getLogger(this.source.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(LogRecord logRecord) {
        Object object = this;
        synchronized (this) {
            WarningListener<? super S>[] warningListenerArray = this.listeners;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (warningListenerArray != null) {
                for (WarningListener<? super S> warningListener : this.listeners) {
                    warningListener.warningOccured((S)this.source, logRecord);
                }
            } else {
                object = this.getLogger();
                logRecord.setLoggerName(((Logger)object).getName());
                if (logRecord instanceof QuietLogRecord) {
                    ((QuietLogRecord)logRecord).clearThrown();
                }
                ((Logger)object).log(logRecord);
            }
            return;
        }
    }

    public void warning(String string, Exception exception) {
        LogRecord logRecord;
        StackTraceElement[] stackTraceElementArray;
        if (exception != null) {
            stackTraceElementArray = exception.getStackTrace();
            string = Exceptions.formatChainedMessages(this.getLocale(), string, exception);
            if (string == null) {
                string = exception.toString();
            }
            logRecord = new QuietLogRecord(string, exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", string);
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            logRecord = new LogRecord(Level.WARNING, string);
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!WarningListeners.isPublic(stackTraceElement)) continue;
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
            break;
        }
        this.warning(logRecord);
    }

    private static boolean isPublic(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        return !string.equals("org.apache.sis.util.logging.WarningListeners") && !string.contains(".internal.") && !string.startsWith("java") && string.indexOf(36) < 0 && stackTraceElement.getMethodName().indexOf(36) < 0;
    }

    public synchronized void addWarningListener(WarningListener<? super S> warningListener) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("listener", warningListener);
        WarningListener<? super S>[] warningListenerArray = this.listeners;
        int n = warningListenerArray != null ? warningListenerArray.length : 0;
        WarningListener[] warningListenerArray2 = new WarningListener[n + 1];
        for (int i = 0; i < n; ++i) {
            WarningListener<? super S> warningListener2 = warningListenerArray[i];
            if (warningListener2 == warningListener) {
                throw new IllegalArgumentException(Errors.format((short)19, warningListener));
            }
            warningListenerArray2[i] = warningListener2;
        }
        warningListenerArray2[n] = warningListener;
        this.listeners = warningListenerArray2;
    }

    public synchronized void removeWarningListener(WarningListener<? super S> warningListener) throws NoSuchElementException {
        ArgumentChecks.ensureNonNull("listener", warningListener);
        WarningListener<? super S>[] warningListenerArray = this.listeners;
        if (warningListenerArray != null) {
            for (int i = 0; i < warningListenerArray.length; ++i) {
                if (warningListenerArray[i] != warningListener) continue;
                if (warningListenerArray.length == 1) {
                    this.listeners = null;
                } else {
                    WarningListener[] warningListenerArray2 = new WarningListener[warningListenerArray.length - 1];
                    System.arraycopy(warningListenerArray, 0, warningListenerArray2, 0, i);
                    System.arraycopy(warningListenerArray, i + 1, warningListenerArray2, i, warningListenerArray2.length - i);
                    this.listeners = warningListenerArray2;
                }
                return;
            }
        }
        throw new NoSuchElementException(Errors.format((short)70, warningListener));
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null;
    }
}

