/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.system.XMLOutputFactory;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredStreamWriter;
import org.apache.sis.xml.Pooled;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class PooledMarshaller
extends Pooled
implements Marshaller {
    private final Marshaller marshaller;

    PooledMarshaller(Marshaller marshaller, Pooled pooled) throws JAXBException {
        super(pooled);
        this.marshaller = marshaller;
        this.initialize(pooled);
    }

    @Override
    protected void reset(Object object, Object object2) throws JAXBException {
        if (object instanceof String) {
            String string = (String)object;
            if (object2 == null && (string.endsWith(".xmlHeaders") || string.equals("jaxb.schemaLocation"))) {
                object2 = "";
            }
            this.marshaller.setProperty(string, object2);
        } else if (object == AttachmentMarshaller.class) {
            this.marshaller.setAttachmentMarshaller((AttachmentMarshaller)object2);
        } else if (object == Schema.class) {
            this.marshaller.setSchema((Schema)object2);
        } else if (object == Marshaller.Listener.class) {
            this.marshaller.setListener((Marshaller.Listener)object2);
        } else if (object == ValidationEventHandler.class) {
            this.marshaller.setEventHandler((ValidationEventHandler)object2);
        } else {
            this.marshaller.setAdapter((Class)object, (XmlAdapter)object2);
        }
    }

    private String getEncoding() throws PropertyException {
        return (String)this.marshaller.getProperty("jaxb.encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshal(Object object, XMLStreamWriter xMLStreamWriter, FilterVersion filterVersion) throws XMLStreamException, JAXBException {
        xMLStreamWriter = new FilteredStreamWriter(xMLStreamWriter, filterVersion);
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLStreamWriter);
        }
        finally {
            context.finish();
        }
        xMLStreamWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Result result) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(result), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, result);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(outputStream, this.getEncoding()), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, outputStream);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, File file) throws JAXBException {
        block9: {
            FilterVersion filterVersion = this.getFilterVersion();
            if (filterVersion != null) {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        this.marshal(object, XMLOutputFactory.createXMLStreamWriter(bufferedOutputStream, this.getEncoding()), filterVersion);
                        break block9;
                    }
                    finally {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                catch (Exception exception) {
                    throw new JAXBException((Throwable)exception);
                }
            }
            Context context = this.begin();
            try {
                this.marshaller.marshal(object, file);
            }
            finally {
                context.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Writer writer) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(writer), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, writer);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(contentHandler), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, contentHandler);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Node node) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(node), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, node);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            xMLStreamWriter = new FilteredStreamWriter(xMLStreamWriter, filterVersion);
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLStreamWriter);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            try {
                this.marshal(object, XMLOutputFactory.createXMLStreamWriter(xMLEventWriter), filterVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLEventWriter);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(Object object) throws JAXBException {
        FilterVersion filterVersion = this.getFilterVersion();
        if (filterVersion != null) {
            throw new UnsupportedOperationException();
        }
        Context context = this.begin();
        try {
            Node node = this.marshaller.getNode(object);
            return node;
        }
        finally {
            context.finish();
        }
    }

    @Override
    void setStandardProperty(String string, Object object) throws PropertyException {
        this.marshaller.setProperty(string, object);
    }

    @Override
    Object getStandardProperty(String string) throws PropertyException {
        return this.marshaller.getProperty(string);
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        super.setAdapter(clazz, a);
        this.marshaller.setAdapter(clazz, a);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        return (A)this.marshaller.getAdapter(clazz);
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.marshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.marshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        super.setEventHandler(validationEventHandler);
        this.marshaller.setEventHandler(validationEventHandler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.marshaller.getEventHandler();
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        if (!this.isPropertySaved(AttachmentMarshaller.class)) {
            this.saveProperty(AttachmentMarshaller.class, this.marshaller.getAttachmentMarshaller());
        }
        this.marshaller.setAttachmentMarshaller(attachmentMarshaller);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.marshaller.getAttachmentMarshaller();
    }

    public void setListener(Marshaller.Listener listener) {
        if (!this.isPropertySaved(Marshaller.Listener.class)) {
            this.saveProperty(Marshaller.Listener.class, this.marshaller.getListener());
        }
        this.marshaller.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.marshaller.getListener();
    }
}

