/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.sis.internal.storage.ChannelData;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class ChannelDataInput
extends ChannelData {
    public final ReadableByteChannel channel;

    public ChannelDataInput(String string, ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, boolean bl) throws IOException {
        super(string, readableByteChannel, byteBuffer);
        this.channel = readableByteChannel;
        if (!bl) {
            byteBuffer.clear();
            readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
        }
    }

    public final int prefetch() throws IOException {
        int n;
        int n2 = this.buffer.limit();
        if (n2 == (n = this.buffer.capacity())) {
            return -2;
        }
        int n3 = this.buffer.position();
        this.buffer.limit(n).position(n2);
        int n4 = this.channel.read(this.buffer);
        while (n4 == 0) {
            this.onEmptyTransfer();
            n4 = this.channel.read(this.buffer);
        }
        this.buffer.limit(this.buffer.position()).position(n3);
        return n4;
    }

    public final boolean hasRemaining() throws IOException {
        if (this.buffer.hasRemaining()) {
            return true;
        }
        this.bufferOffset += (long)this.buffer.limit();
        this.buffer.clear();
        int n = this.channel.read(this.buffer);
        while (n == 0) {
            this.onEmptyTransfer();
            n = this.channel.read(this.buffer);
        }
        this.buffer.flip();
        return n >= 0;
    }

    public final void ensureBufferContains(int n) throws EOFException, IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int n2;
            this.bufferOffset += (long)this.buffer.position();
            this.buffer.compact();
            do {
                if ((n2 = this.channel.read(this.buffer)) > 0) continue;
                if (n2 != 0) {
                    throw new EOFException(this.eof());
                }
                this.onEmptyTransfer();
            } while ((n -= n2) > 0);
            this.buffer.flip();
        }
    }

    private void ensureNonEmpty() throws IOException {
        if (!this.hasRemaining()) {
            throw new EOFException(this.eof());
        }
    }

    private String eof() {
        return Errors.format((short)109, (Object)this.filename);
    }

    final void pushBack() {
        this.buffer.position(this.buffer.position() - 1);
    }

    public final int readBit() throws IOException {
        return (int)this.readBits(1);
    }

    public final long readBits(int n) throws IOException {
        ArgumentChecks.ensureBetween((String)"numBits", (int)0, (int)64, (int)n);
        if (n == 0) {
            return 0L;
        }
        int n2 = this.getBitOffset();
        long l = this.readByte() & 255 >>> n2;
        n -= 8 - n2;
        while (n > 0) {
            l = l << 8 | (long)this.readUnsignedByte();
            n -= 8;
        }
        if (n != 0) {
            l >>>= -n;
            n += 8;
            this.pushBack();
        }
        this.setBitOffset(n);
        return l;
    }

    public final byte readByte() throws IOException {
        this.ensureBufferContains(1);
        return this.buffer.get();
    }

    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final short readShort() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final char readChar() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getChar();
    }

    public final int readInt() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getInt();
    }

    public final long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final long readLong() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getLong();
    }

    public final float readFloat() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getFloat();
    }

    public final double readDouble() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getDouble();
    }

    public final byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public final char[] readChars(int n) throws IOException {
        char[] cArray = new char[n];
        this.readFully(cArray, 0, n);
        return cArray;
    }

    public final short[] readShorts(int n) throws IOException {
        short[] sArray = new short[n];
        this.readFully(sArray, 0, n);
        return sArray;
    }

    public final int[] readInts(int n) throws IOException {
        int[] nArray = new int[n];
        this.readFully(nArray, 0, n);
        return nArray;
    }

    public final long[] readLongs(int n) throws IOException {
        long[] lArray = new long[n];
        this.readFully(lArray, 0, n);
        return lArray;
    }

    public final float[] readFloats(int n) throws IOException {
        float[] fArray = new float[n];
        this.readFully(fArray, 0, n);
        return fArray;
    }

    public final double[] readDoubles(int n) throws IOException {
        double[] dArray = new double[n];
        this.readFully(dArray, 0, n);
        return dArray;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 != 0) {
            this.ensureNonEmpty();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public final void readFully(final char[] cArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private CharBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asCharBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(cArray, n, n2);
            }
        }.readFully(2, n, n2);
    }

    public final void readFully(final short[] sArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private ShortBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asShortBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(sArray, n, n2);
            }
        }.readFully(2, n, n2);
    }

    public final void readFully(final int[] nArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private IntBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asIntBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(nArray, n, n2);
            }
        }.readFully(4, n, n2);
    }

    public final void readFully(final long[] lArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private LongBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asLongBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(lArray, n, n2);
            }
        }.readFully(8, n, n2);
    }

    public final void readFully(final float[] fArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private FloatBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asFloatBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(fArray, n, n2);
            }
        }.readFully(4, n, n2);
    }

    public final void readFully(final double[] dArray, int n, int n2) throws IOException {
        new ArrayReader(){
            private DoubleBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataInput.this.buffer.asDoubleBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.get(dArray, n, n2);
            }
        }.readFully(8, n, n2);
    }

    public final String readString(int n, String string) throws IOException {
        if (this.buffer.hasArray() && n <= this.buffer.capacity()) {
            this.ensureBufferContains(n);
            int n2 = this.buffer.position();
            this.buffer.position(n2 + n);
            return new String(this.buffer.array(), this.buffer.arrayOffset() + n2, n, string);
        }
        return new String(this.readBytes(n), string);
    }

    @Override
    public final void seek(long l) throws IOException {
        long l2 = l - this.bufferOffset;
        if (l2 >= 0L && l2 <= (long)this.buffer.limit()) {
            this.buffer.position((int)l2);
        } else if (this.channel instanceof FileChannel) {
            ((FileChannel)this.channel).position(this.channelOffset + l);
            this.bufferOffset = l;
            this.buffer.clear().limit(0);
        } else if (l2 >= 0L) {
            do {
                this.bufferOffset += (long)this.buffer.limit();
                l2 -= (long)this.buffer.limit();
                this.buffer.clear();
                int n = this.channel.read(this.buffer);
                if (n <= 0) {
                    if (n != 0) {
                        throw new EOFException(this.eof());
                    }
                    this.onEmptyTransfer();
                }
                this.buffer.flip();
            } while (l2 > (long)this.buffer.limit());
            this.buffer.position((int)l2);
        } else {
            throw new IOException(Errors.format((short)103, (Object)this.filename));
        }
        this.clearBitOffset();
    }

    private abstract class ArrayReader {
        private ArrayReader() {
        }

        abstract Buffer createView();

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int n) {
            ChannelDataInput.this.buffer.position(ChannelDataInput.this.buffer.position() + n);
        }

        final void readFully(int n, int n2, int n3) throws IOException {
            ChannelDataInput.this.ensureBufferContains(Math.min(n3 * n, ChannelDataInput.this.buffer.capacity()));
            Buffer buffer = this.createView();
            int n4 = Math.min(buffer.remaining(), n3);
            this.transfer(n2, n4);
            this.skipInBuffer(n4 * n);
            while ((n3 -= n4) != 0) {
                ChannelDataInput.this.ensureBufferContains(n);
                buffer.rewind().limit(ChannelDataInput.this.buffer.remaining() / n);
                n4 = Math.min(buffer.remaining(), n3);
                this.transfer(n2 += n4, n4);
                this.skipInBuffer(n4 * n);
            }
        }
    }
}

