/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private StandardContext context = null;

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    public final void invoke(Request request, Response response) throws IOException, ServletException {
        ServletRequestListener listener;
        int i;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            String requestURI = request.getDecodedRequestURI();
            this.notFound(requestURI, response);
            return;
        }
        while (this.context.getPaused()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null) {
            String requestURI = request.getDecodedRequestURI();
            this.notFound(requestURI, response);
            return;
        }
        Object[] instances = this.context.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), (ServletRequest)request.getRequest());
            for (i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    return;
                }
            }
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
        if (instances != null && instances.length > 0) {
            for (i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)sm.getString("standardContext.requestListener.requestDestroy", instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                }
            }
        }
    }

    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, event);
    }

    private void notFound(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(404, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

