/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.script.Platform;
import org.codehaus.mojo.appassembler.daemon.script.ScriptGenerator;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultScriptGenerator
extends AbstractLogEnabled
implements ScriptGenerator {
    private static final String DEFAULT_LICENSE_HEADER = "default-license-header.txt";

    private boolean isDefaultLicenseHeaderRequested(Daemon daemon) {
        if (daemon.getLicenseHeaderFile() == null) {
            return true;
        }
        if (daemon.getLicenseHeaderFile().trim().length() > 0) {
            return false;
        }
        return false;
    }

    private String getLicenseHeader(Platform platform, Daemon daemon) throws DaemonGeneratorException {
        List lines = null;
        if (this.isDefaultLicenseHeaderRequested(daemon)) {
            this.getLogger().debug("Using default licence file (default-license-header.txt.");
            lines = this.readLicenseHeader();
        } else {
            this.getLogger().debug("Using license file: " + daemon.getLicenseHeaderFile());
            lines = this.readLicenseHeaderFromFile(new File(daemon.getLicenseHeaderFile()));
        }
        StringBuffer resultLines = new StringBuffer();
        for (int i = 0; i < lines.size(); ++i) {
            String licenseLine = platform.getCommentPrefix() + lines.get(i);
            resultLines.append(licenseLine.trim() + platform.getNewLine());
        }
        return resultLines.toString();
    }

    private List readLicenseHeader() throws DaemonGeneratorException {
        ArrayList<String> result = new ArrayList<String>();
        InputStream in = this.getClass().getResourceAsStream(DEFAULT_LICENSE_HEADER);
        InputStreamReader inr = new InputStreamReader(in);
        try {
            String str;
            BufferedReader bufRead = new BufferedReader(inr);
            while ((str = bufRead.readLine()) != null) {
                result.add(str);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Internal error: could not read license header template file (license-header.txt)");
        }
        return result;
    }

    private List readLicenseHeaderFromFile(File licenseHeader) throws DaemonGeneratorException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(licenseHeader));
            while ((str = in.readLine()) != null) {
                result.add(str);
            }
            in.close();
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Internal error: could not read license header template file " + licenseHeader.getName());
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createBinScript(String platformName, Daemon daemon, File outputDirectory, String binFolder) throws DaemonGeneratorException {
        Platform platform = Platform.getInstance(platformName);
        InputStream in = null;
        FileWriter out = null;
        try {
            in = this.getClass().getResourceAsStream(platformName + "BinTemplate");
            if (in == null) {
                throw new DaemonGeneratorException("Internal error: could not find template for platform '" + platformName + "'.");
            }
            InputStreamReader reader = new InputStreamReader(in);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("MAINCLASS", daemon.getMainClass());
            context.put("CLASSPATH", platform.getClassPath(daemon));
            context.put("EXTRA_JVM_ARGUMENTS", platform.getExtraJvmArguments(daemon.getJvmSettings()));
            context.put("APP_NAME", daemon.getId());
            context.put("ENV_SETUP", platform.getEnvSetup(daemon));
            context.put("REPO", daemon.getRepositoryName());
            context.put("LICENSE_HEADER", this.getLicenseHeader(platform, daemon));
            if (platform.isShowConsoleWindow(daemon)) {
                context.put("JAVA_BINARY", "java");
            } else {
                context.put("JAVA_BINARY", "start /min javaw");
            }
            String appArguments = platform.getAppArguments(daemon);
            if (appArguments != null) {
                context.put("APP_ARGUMENTS", appArguments + " ");
            } else {
                context.put("APP_ARGUMENTS", "");
            }
            String interpolationToken = platform.getInterpolationToken();
            InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, interpolationToken, interpolationToken);
            String programName = "";
            if (daemon.getId() == null || daemon.getId().trim().equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(daemon.getMainClass(), ".");
                while (tokenizer.hasMoreElements()) {
                    programName = tokenizer.nextToken();
                }
                programName = programName.toLowerCase();
            } else {
                programName = daemon.getId();
            }
            File binDir = new File(outputDirectory, binFolder);
            FileUtils.forceMkdir((File)binDir);
            File binFile = new File(binDir, programName + platform.getBinFileExtension());
            out = new FileWriter(binFile);
            this.getLogger().debug("Writing shell file for platform '" + platform.getName() + "' to '" + binFile.getAbsolutePath() + "'.");
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        }
        catch (FileNotFoundException e) {
            try {
                throw new DaemonGeneratorException("Failed to get template for bin file.", e);
                catch (IOException e2) {
                    throw new DaemonGeneratorException("Failed to write bin file.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
        IOUtil.close((InputStream)in);
    }
}

