/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

public class ReserveListenerPortMojo
extends AbstractMojo {
    private String[] portNames = new String[0];
    private File outputFile;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Properties properties = this.project.getProperties();
        if (this.outputFile != null) {
            properties = new Properties();
        }
        for (String portName : this.portNames) {
            String unusedPort = Integer.toString(this.getNextAvailablePort());
            properties.put(portName, unusedPort);
            this.getLog().info((CharSequence)("Reserved port " + unusedPort + " for " + portName));
        }
        if (this.outputFile != null) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.outputFile);
                properties.store(os, null);
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException(e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtil.close(os);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)os);
        }
    }

    private int getNextAvailablePort() throws MojoExecutionException {
        int unusedPort = 0;
        try {
            ServerSocket socket = new ServerSocket(0);
            unusedPort = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting an available port from system", (Exception)e);
        }
        return unusedPort;
    }
}

