/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanCircularDependencies
implements EnforcerRule {
    private transient DependencyGraphBuilder graphBuilder;
    private String message;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.warnIfMaven2(helper);
        Log log = helper.getLog();
        try {
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ComponentLookupException e) {
            try {
                this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class.getName(), "maven2");
            }
            catch (ComponentLookupException e1) {
                throw new EnforcerRuleException("Unable to lookup DependencyGraphBuilder: ", (Exception)((Object)e));
            }
        }
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            Set<Artifact> artifacts = this.getDependenciesToCheck(project);
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    log.debug((CharSequence)("groupId: " + artifact.getGroupId() + project.getGroupId()));
                    if (!artifact.getGroupId().equals(project.getGroupId())) continue;
                    log.debug((CharSequence)("artifactId: " + artifact.getArtifactId() + " " + project.getArtifactId()));
                    if (!artifact.getArtifactId().equals(project.getArtifactId())) continue;
                    StringBuilder buf = new StringBuilder(this.getErrorMessage());
                    buf.append("\n  ").append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append("\n ");
                    throw new EnforcerRuleException(buf.toString());
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            log.error((CharSequence)"Error checking for circular dependencies", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void warnIfMaven2(EnforcerRuleHelper helper) {
        Log log = helper.getLog();
        try {
            RuntimeInformation rti = (RuntimeInformation)helper.getComponent(RuntimeInformation.class);
            ArtifactVersion detectedMavenVersion = rti.getApplicationVersion();
            log.debug((CharSequence)("Detected Maven Version: " + detectedMavenVersion));
            if (detectedMavenVersion.getMajorVersion() == 2) {
                log.warn((CharSequence)"Circular dependencies cannot exist with Maven 2. So that rule is of no use for that Maven version. See rule documentation at http://mojo.codehaus.org/extra-enforcer-rules/banCircularDependencies.html");
            }
        }
        catch (ComponentLookupException e) {
            log.warn((CharSequence)"Unable to detect Maven version. Please report this issue to the mojo@codehaus project");
        }
    }

    protected Set<Artifact> getDependenciesToCheck(MavenProject project) {
        Set<Artifact> dependencies = null;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(project, null);
            dependencies = this.getAllDescendants(node);
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = this.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    private String getErrorMessage() {
        if (this.message == null) {
            return "Circular Dependency found. Your project's groupId:artifactId combination must not exist in the list of direct or transitive dependencies.";
        }
        return this.message;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }
}

