/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Source {
    private File location;
    private List includes;
    private List excludes;
    private String destination;
    private boolean noDefaultExcludes;
    private String targetArchitecture;
    private Pattern targetArchitecturePattern;
    private String targetOSName;
    private Pattern targetOSNamePattern;
    private boolean filter;

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File loc) {
        this.location = loc;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List incl) {
        this.includes = incl;
    }

    public List getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List excl) {
        this.excludes = excl;
    }

    public boolean getNoDefaultExcludes() {
        return this.noDefaultExcludes;
    }

    public void setNoDefaultExcludes(boolean noDefExcl) {
        this.noDefaultExcludes = noDefExcl;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getTargetArchitecture() {
        return this.targetArchitecture;
    }

    public void setTargetArchitecture(String targetArch) {
        this.targetArchitecture = targetArch;
        this.targetArchitecturePattern = targetArch == null ? null : Pattern.compile(targetArch.toLowerCase(Locale.ENGLISH));
    }

    boolean matchesArchitecture(String architecture) {
        return this.targetArchitecturePattern == null ? true : this.targetArchitecturePattern.matcher(architecture).matches();
    }

    public String getTargetOSName() {
        return this.targetOSName;
    }

    public void setTargetOSName(String targetOSName) {
        this.targetOSName = targetOSName;
        this.targetOSNamePattern = targetOSName != null ? Pattern.compile(targetOSName) : null;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    boolean matchesOSName(String osName) {
        return this.targetOSNamePattern == null ? true : this.targetOSNamePattern.matcher(osName).matches();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.location == null) {
            sb.append("nowhere");
        } else {
            sb.append("\"" + this.location + "\"");
        }
        if (this.includes != null) {
            sb.append(" incl:" + this.includes);
        }
        if (this.excludes != null) {
            sb.append(" excl:" + this.excludes);
        }
        if (this.destination != null) {
            sb.append(" destination: ");
            sb.append(this.destination);
        }
        sb.append(" filter: " + Boolean.toString(this.filter));
        if (this.noDefaultExcludes) {
            sb.append(" [no default excludes]");
        }
        if (this.targetArchitecture != null) {
            sb.append(" targetArch: ");
            sb.append(this.targetArchitecture);
        }
        sb.append("}");
        return sb.toString();
    }
}

