/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.mojo.tomcat.TomcatManagerException;

public class TomcatManager {
    private static final String MANAGER_CHARSET = "UTF-8";
    private URL url;
    private String username;
    private String password;
    private String charset;
    private String userAgent;

    public TomcatManager(URL url) {
        this(url, "admin");
    }

    public TomcatManager(URL url, String username) {
        this(url, username, "");
    }

    public TomcatManager(URL url, String username, String password) {
        this(url, username, password, "ISO-8859-1");
    }

    public TomcatManager(URL url, String username, String password, String charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String deploy(String path, URL war) throws TomcatManagerException, IOException {
        return this.deploy(path, war, false);
    }

    public String deploy(String path, URL war, boolean update) throws TomcatManagerException, IOException {
        return this.deploy(path, war, update, null);
    }

    public String deploy(String path, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, null, war, null, update, tag);
    }

    public String deploy(String path, InputStream war) throws TomcatManagerException, IOException {
        return this.deploy(path, war, false);
    }

    public String deploy(String path, InputStream war, boolean update) throws TomcatManagerException, IOException {
        return this.deploy(path, war, update, null);
    }

    public String deploy(String path, InputStream war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, null, null, war, update, tag);
    }

    public String deployContext(String path, URL config) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, false);
    }

    public String deployContext(String path, URL config, boolean update) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, update, null);
    }

    public String deployContext(String path, URL config, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, null, update, tag);
    }

    public String deployContext(String path, URL config, URL war) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, war, false);
    }

    public String deployContext(String path, URL config, URL war, boolean update) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, war, update, null);
    }

    public String deployContext(String path, URL config, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, config, war, null, update, tag);
    }

    public String undeploy(String path) throws TomcatManagerException, IOException {
        return this.invoke("/undeploy?path=" + URLEncoder.encode(path, this.charset));
    }

    public String reload(String path) throws TomcatManagerException, IOException {
        return this.invoke("/reload?path=" + URLEncoder.encode(path, this.charset));
    }

    public String start(String path) throws TomcatManagerException, IOException {
        return this.invoke("/start?path=" + URLEncoder.encode(path, this.charset));
    }

    public String stop(String path) throws TomcatManagerException, IOException {
        return this.invoke("/stop?path=" + URLEncoder.encode(path, this.charset));
    }

    public String list() throws TomcatManagerException, IOException {
        return this.invoke("/list");
    }

    public String getServerInfo() throws TomcatManagerException, IOException {
        return this.invoke("/serverinfo");
    }

    public String getResources() throws TomcatManagerException, IOException {
        return this.getResources(null);
    }

    public String getResources(String type) throws TomcatManagerException, IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/resources");
        if (type != null) {
            buffer.append("?type=" + URLEncoder.encode(type, this.charset));
        }
        return this.invoke(buffer.toString());
    }

    public String getRoles() throws TomcatManagerException, IOException {
        return this.invoke("/roles");
    }

    public String getSessions(String path) throws TomcatManagerException, IOException {
        return this.invoke("/sessions?path=" + URLEncoder.encode(path, this.charset));
    }

    protected String invoke(String path) throws TomcatManagerException, IOException {
        return this.invoke(path, null);
    }

    protected String invoke(String path, InputStream data) throws TomcatManagerException, IOException {
        String response;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url + path).openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        if (data == null) {
            connection.setDoOutput(false);
            connection.setRequestMethod("GET");
        } else {
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
        }
        if (this.userAgent != null) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        connection.setRequestProperty("Authorization", this.toAuthorization(this.username, this.password));
        connection.connect();
        if (data != null) {
            this.pipe(data, connection.getOutputStream());
        }
        if (!(response = this.toString(connection.getInputStream(), MANAGER_CHARSET)).startsWith("OK -")) {
            throw new TomcatManagerException(response);
        }
        return response;
    }

    private String deployImpl(String path, URL config, URL war, InputStream data, boolean update, String tag) throws TomcatManagerException, IOException {
        StringBuffer buffer = new StringBuffer("/deploy");
        buffer.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (config != null) {
            buffer.append("&config=").append(URLEncoder.encode(config.toString(), this.charset));
        }
        if (war != null) {
            buffer.append("&war=").append(URLEncoder.encode(war.toString(), this.charset));
        } else {
            buffer.append("&war=");
        }
        if (update) {
            buffer.append("&update=true");
        }
        if (tag != null) {
            buffer.append("&tag=").append(URLEncoder.encode(tag, this.charset));
        }
        return this.invoke(buffer.toString(), data);
    }

    private String toAuthorization(String username, String password) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(username).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        int n;
        out = new BufferedOutputStream(out);
        byte[] bytes = new byte[4096];
        while ((n = in.read(bytes)) != -1) {
            out.write(bytes, 0, n);
        }
        out.flush();
        out.close();
        in.close();
    }

    private String toString(InputStream in, String charset) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuffer buffer = new StringBuffer();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            buffer.append(chars, 0, n);
        }
        return buffer.toString();
    }
}

